<?php
/**
 * 前台控制器基类
 */
class FirstendAction extends TopAction {

    protected $visitor = null;
    public function _initialize() {
        parent::_initialize();
        //网站状态
        if (!C('ftx_site_status')) {
            header('Content-Type:text/html; charset=utf-8');
            exit(C('ftx_closed_reason'));
        }		
		
		$url = C('ftx_site_url');
		$str = parse_url($url); 
		$this->assign('str', $str); 
        $this->assign('nav_curr', '');		
		$this->assign("time",date('Ymdhi',time()));
		$this->assign("year",date('Y',time()));
		
		$map['status'] = 1;
		$catelist = D('article_cate')->where($map)->order('ordid asc')->select();
		foreach ($catelist as $key => $val) {
			$catelist[$key] = $val;
		}		
		$ename = I('ename');
		$cat = I('cid');
		if($ename){
		$cinfo = D('article_cate')->where(array('ename'=>$ename))->find();	
		}
		if($cat){
		$cinfo = D('article_cate')->where(array('id'=>$cat))->find();	
		}
		$wap_nav = array();
		foreach ($catelist as $key => $vol) {
			$wap_nav[$key]['name'] = $vol['name']; 
			$wap_nav[$key]['cid'] = $vol['id'];
			$wap_nav[$key]['url'] = U('/'.$vol['ename']); 
		}
		array_unshift($wap_nav, array('cid'=>'','name'=>'首页','url'=>'/'));
		array_push($wap_nav, array('cid'=>'bjx','name'=>'百家姓','url'=>U('/bjx')));
		array_push($wap_nav, array('cid'=>'mz','name'=>'姓名打分','url'=>U('/mz')));
		$nav = json_encode($wap_nav,320);
		$this->assign('navlist', $nav);		
    }
    
   

    

    /**
     * SEO设置
     */
    protected function _config_seo($seo_info = array(), $data = array()) {
        $page_seo = array(
            'title' => C('ftx_site_title'),
            'keywords' => C('ftx_site_keywords'),
            'description' => C('ftx_site_description')
        );
        $page_seo = array_merge($page_seo, $seo_info);
        //开始替换
        $searchs = array('{site_name}', '{site_title}', '{site_keywords}', '{site_description}');
        $replaces = array(C('ftx_site_name'), C('ftx_site_title'), C('ftx_site_keywords'), C('ftx_site_description'));
        preg_match_all("/\{([a-z0-9_-]+?)\}/", implode(' ', array_values($page_seo)), $pageparams);
        if ($pageparams) {
            foreach ($pageparams[1] as $var) {
                $searchs[] = '{' . $var . '}';
                $replaces[] = $data[$var] ? strip_tags($data[$var]) : '';
            }
            //符号
            $searchspace = array('((\s*\-\s*)+)', '((\s*\,\s*)+)', '((\s*\|\s*)+)', '((\s*\t\s*)+)', '((\s*_\s*)+)');
            $replacespace = array('-', ',', '|', ' ', '_');
            foreach ($page_seo as $key => $val) {
                $page_seo[$key] = trim(preg_replace($searchspace, $replacespace, str_replace($searchs, $replaces, $val)), ' ,-|_');
            }
        }
        $this->assign('page_seo', $page_seo);
    }

    

    /**
     * 前台分页统一
     */
    protected function _pager($count, $pagesize) {
        $pager = new Page($count, $pagesize);
        $pager->rollPage = 5;
		$pager->setConfig('header','条记录');
        $pager->setConfig('prev', '上一页');
		$pager->setConfig('next', '下一页');
		$pager->setConfig('first', '第一页');
		$pager->setConfig('last', '最后一页');
        $pager->setConfig('theme', '%upPage% %first% %linkPage% %end% %downPage%');
        return $pager;
    }
}

?>