// -----------------------------------------------------------------------
// Licensed to The .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// -----------------------------------------------------------------------

using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Kerberos.NET;
using Kerberos.NET.Crypto;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Tests.Kerberos.NET
{
    [TestClass]
    public class ClaimsTests : BaseTest
    {
        [TestMethod]
        public async Task ParseClaims()
        {
            var validator = new KerberosValidator(new KeyTable(ReadDataFile("sample.keytab"))) { ValidateAfterDecrypt = DefaultActions };

            var authenticator = new KerberosAuthenticator(validator);

            var result = await authenticator.Authenticate(RC4TicketClaims);

            Assert.IsNotNull(result);

            Assert.IsTrue(result.Claims.Any());

            Assert.IsTrue(result.Claims.Any(c => c.Type == "ad://ext/employeeType:88d4d68c56082042" && c.Value == "lazy"));

            Assert.AreEqual(2, result.Claims.Count(c => c.Type == "ad://ext/localeID:88d4d68c6aa51687"));

            foreach (var c in result.Claims)
            {
                Debug.WriteLine($"{c.Type}: {c.Value}");
            }
        }

        [TestMethod]
        public async Task ValidatorClaimsPresent()
        {
            var validator = new KerberosValidator(new KeyTable(ReadDataFile("sample.keytab"))) { ValidateAfterDecrypt = DefaultActions };

            var authenticator = new KerberosAuthenticator(validator);

            var result = await authenticator.Authenticate(RC4TicketClaims);

            Assert.IsNotNull(result);

            var kerbIdentity = result as KerberosIdentity;

            Assert.IsNotNull(kerbIdentity);

            Assert.IsTrue(result.Claims.Any());

            Assert.IsFalse(result.Claims.Any(c => c.Type == "Validated"));

            Assert.AreEqual(DefaultActions, kerbIdentity.ValidationMode);
        }
    }
}