// -----------------------------------------------------------------------
// Licensed to The .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// -----------------------------------------------------------------------

using System;
using System.Linq;
using Kerberos.NET.Crypto;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Tests.Kerberos.NET
{
    [TestClass]
    public class PKInitOctetString2KeyTests
    {
        // Test vectors originally from RFC 4556 Appendix B
        // https://tools.ietf.org/html/rfc4556#appendix-B

        [TestMethod]
        public void String2Key_256_0()
        {
            var key = new byte[256];

            var result = PKInitString2Key.String2Key(key, 32);

            var expected = new byte[]
            {
                0x5e, 0xe5, 0x0d, 0x67, 0x5c, 0x80, 0x9f, 0xe5, 0x9e, 0x4a, 0x77, 0x62, 0xc5, 0x4b, 0x65, 0x83,
                0x75, 0x47, 0xea, 0xfb, 0x15, 0x9b, 0xd8, 0xcd, 0xc7, 0x5f, 0xfc, 0xa5, 0x91, 0x1e, 0x4c, 0x41
            };

            Assert.IsTrue(result.Span.SequenceEqual(expected));
        }

        [TestMethod]
        public void String2Key_128_0()
        {
            var key = new byte[128];

            var result = PKInitString2Key.String2Key(key, 32);

            var expected = new byte[]
            {
                0xac, 0xf7, 0x70, 0x7c, 0x08, 0x97, 0x3d, 0xdf, 0xdb, 0x27, 0xcd, 0x36, 0x14, 0x42, 0xcc, 0xfb,
                0xa3, 0x55, 0xc8, 0x88, 0x4c, 0xb4, 0x72, 0xf3, 0x7d, 0xa6, 0x36, 0xd0, 0x7d, 0x56, 0x78, 0x7e
            };

            Assert.IsTrue(result.Span.SequenceEqual(expected));
        }

        [TestMethod]
        public void String2Key_128_IncrementingSequence_Len_77()
        {
            var key = new byte[]
            {
                0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
                0x10, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e,
                0x0f, 0x10, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d,
                0x0e, 0x0f, 0x10, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c,
                0x0d, 0x0e, 0x0f, 0x10, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08
            };

            var result = PKInitString2Key.String2Key(key, 32);

            var expected = new byte[]
            {
                0x00, 0x53, 0x95, 0x3b, 0x84, 0xc8, 0x96, 0xf4, 0xeb, 0x38, 0x5c, 0x3f, 0x2e, 0x75, 0x1c, 0x4a,
                0x59, 0x0e, 0xd6, 0xff, 0xad, 0xca, 0x6f, 0xf6, 0x4f, 0x47, 0xeb, 0xeb, 0x8d, 0x78, 0x0f, 0xfc
            };

            Assert.IsTrue(result.Span.SequenceEqual(expected));
        }
    }
}