﻿// -----------------------------------------------------------------------
// Licensed to The .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// -----------------------------------------------------------------------

// This is a generated file.
// The generation template has been modified from .NET Runtime implementation

using System;
using System.Collections.Generic;
using System.Security.Cryptography;
using System.Security.Cryptography.Asn1;
using Kerberos.NET.Crypto;
using Kerberos.NET.Asn1;

namespace Kerberos.NET.Entities
{
    public partial class KrbAuthPack
    {
        /*
          AuthPack ::= SEQUENCE {
            pkAuthenticator         [0] PKAuthenticator,
            clientPublicValue       [1] SubjectPublicKeyInfo OPTIONAL,
          		   - - Type SubjectPublicKeyInfo is defined in
          		   - - [RFC3280].
          		   - - Specifies Diffie-Hellman domain parameters
          		   - - and the client's public key value [IEEE1363].
          		   - - The DH public key value is encoded as a BIT
          		   - - STRING according to [RFC3279].
          		   - - This field is present only if the client wishes
          		   - - to use the Diffie-Hellman key agreement method.
            supportedCMSTypes       [2] SEQUENCE OF AlgorithmIdentifier
          							  OPTIONAL,
          		   - - Type AlgorithmIdentifier is defined in
          		   - - [RFC3280].
          		   - - List of CMS algorithm [RFC3370] identifiers
          		   - - that identify key transport algorithms, or
          		   - - content encryption algorithms, or signature
          		   - - algorithms supported by the client in order of
          		   - - (decreasing) preference.
            clientDHNonce           [3] DHNonce OPTIONAL,
          		   - - Present only if the client indicates that it
          		   - - wishes to reuse DH keys or to allow the KDC to
          		   - - do so.
            ...
          }
         */
    
        public KrbPKAuthenticator PKAuthenticator { get; set; }
  
        public KrbSubjectPublicKeyInfo ClientPublicValue { get; set; }
  
        public KrbAlgorithmIdentifier[] SupportedCMSTypes { get; set; }
  
        public ReadOnlyMemory<byte>? ClientDHNonce { get; set; }
  
        // Encoding methods
        public ReadOnlyMemory<byte> Encode()
        {
            var writer = new AsnWriter(AsnEncodingRules.DER);

            Encode(writer);

            return writer.EncodeAsMemory();
        }
 
        internal void Encode(AsnWriter writer)
        {
            Encode(writer, Asn1Tag.Sequence);
        }
        
        internal void Encode(AsnWriter writer, Asn1Tag tag)
        {
            writer.PushSequence(tag);
            
            writer.PushSequence(new Asn1Tag(TagClass.ContextSpecific, 0));
            PKAuthenticator?.Encode(writer);
            writer.PopSequence(new Asn1Tag(TagClass.ContextSpecific, 0));

            if (Asn1Extension.HasValue(ClientPublicValue))
            {
                writer.PushSequence(new Asn1Tag(TagClass.ContextSpecific, 1));
                ClientPublicValue?.Encode(writer);
                writer.PopSequence(new Asn1Tag(TagClass.ContextSpecific, 1));
            }

            if (Asn1Extension.HasValue(SupportedCMSTypes))
            {
                writer.PushSequence(new Asn1Tag(TagClass.ContextSpecific, 2));
                writer.PushSequence();
            
                for (int i = 0; i < SupportedCMSTypes.Length; i++)
                {
                    SupportedCMSTypes[i]?.Encode(writer); 
                }

                writer.PopSequence();

                writer.PopSequence(new Asn1Tag(TagClass.ContextSpecific, 2));
            }
  

            if (Asn1Extension.HasValue(ClientDHNonce))
            {
                writer.PushSequence(new Asn1Tag(TagClass.ContextSpecific, 3));
                writer.WriteOctetString(ClientDHNonce.Value.Span);
                writer.PopSequence(new Asn1Tag(TagClass.ContextSpecific, 3));
            }
            writer.PopSequence(tag);
        }
        
        internal void EncodeApplication(AsnWriter writer, Asn1Tag tag)
        {
            writer.PushSequence(tag);
            
            this.Encode(writer, Asn1Tag.Sequence);
            
            writer.PopSequence(tag);
        }       
        
        public virtual ReadOnlyMemory<byte> EncodeApplication() => new ReadOnlyMemory<byte>();
         
        internal ReadOnlyMemory<byte> EncodeApplication(Asn1Tag tag)
        {
            using (var writer = new AsnWriter(AsnEncodingRules.DER))
            {
                EncodeApplication(writer, tag);

                return writer.EncodeAsMemory();
            }
        }
        
        public static KrbAuthPack Decode(ReadOnlyMemory<byte> data)
        {
            return Decode(data, AsnEncodingRules.DER);
        }

        internal static KrbAuthPack Decode(ReadOnlyMemory<byte> encoded, AsnEncodingRules ruleSet)
        {
            return Decode(Asn1Tag.Sequence, encoded, ruleSet);
        }
        
        internal static KrbAuthPack Decode(Asn1Tag expectedTag, ReadOnlyMemory<byte> encoded)
        {
            AsnReader reader = new AsnReader(encoded, AsnEncodingRules.DER);
            
            Decode(reader, expectedTag, out KrbAuthPack decoded);
            reader.ThrowIfNotEmpty();
            return decoded;
        }

        internal static KrbAuthPack Decode(Asn1Tag expectedTag, ReadOnlyMemory<byte> encoded, AsnEncodingRules ruleSet)
        {
            AsnReader reader = new AsnReader(encoded, ruleSet);
            
            Decode(reader, expectedTag, out KrbAuthPack decoded);
            reader.ThrowIfNotEmpty();
            return decoded;
        }

        internal static void Decode<T>(AsnReader reader, out T decoded)
          where T: KrbAuthPack, new()
        {
            if (reader == null)
            {
                throw new ArgumentNullException(nameof(reader));
            }
            
            Decode(reader, Asn1Tag.Sequence, out decoded);
        }

        internal static void Decode<T>(AsnReader reader, Asn1Tag expectedTag, out T decoded)
          where T: KrbAuthPack, new()
        {
            if (reader == null)
            {
                throw new ArgumentNullException(nameof(reader));
            }

            decoded = new T();
            
            AsnReader sequenceReader = reader.ReadSequence(expectedTag);
            AsnReader explicitReader;
            AsnReader collectionReader;
            
            explicitReader = sequenceReader.ReadSequence(new Asn1Tag(TagClass.ContextSpecific, 0));
            KrbPKAuthenticator.Decode<KrbPKAuthenticator>(explicitReader, out KrbPKAuthenticator tmpPKAuthenticator);
            decoded.PKAuthenticator = tmpPKAuthenticator;

            explicitReader.ThrowIfNotEmpty();

            if (sequenceReader.HasData && sequenceReader.PeekTag().HasSameClassAndValue(new Asn1Tag(TagClass.ContextSpecific, 1)))
            {
                explicitReader = sequenceReader.ReadSequence(new Asn1Tag(TagClass.ContextSpecific, 1));                
            
                KrbSubjectPublicKeyInfo.Decode<KrbSubjectPublicKeyInfo>(explicitReader, out KrbSubjectPublicKeyInfo tmpClientPublicValue);
                decoded.ClientPublicValue = tmpClientPublicValue;
                explicitReader.ThrowIfNotEmpty();
            }

            if (sequenceReader.HasData && sequenceReader.PeekTag().HasSameClassAndValue(new Asn1Tag(TagClass.ContextSpecific, 2)))
            {
                explicitReader = sequenceReader.ReadSequence(new Asn1Tag(TagClass.ContextSpecific, 2));                
            
                // Decode SEQUENCE OF for SupportedCMSTypes
                {
                    collectionReader = explicitReader.ReadSequence();
                    var tmpList = new List<KrbAlgorithmIdentifier>();
                    KrbAlgorithmIdentifier tmpItem;

                    while (collectionReader.HasData)
                    {
                        KrbAlgorithmIdentifier.Decode<KrbAlgorithmIdentifier>(collectionReader, out KrbAlgorithmIdentifier tmp);
                        tmpItem = tmp; 
                        tmpList.Add(tmpItem);
                    }

                    decoded.SupportedCMSTypes = tmpList.ToArray();
                }
                explicitReader.ThrowIfNotEmpty();
            }

            if (sequenceReader.HasData && sequenceReader.PeekTag().HasSameClassAndValue(new Asn1Tag(TagClass.ContextSpecific, 3)))
            {
                explicitReader = sequenceReader.ReadSequence(new Asn1Tag(TagClass.ContextSpecific, 3));                
            

                if (explicitReader.TryReadPrimitiveOctetStringBytes(out ReadOnlyMemory<byte> tmpClientDHNonce))
                {
                    decoded.ClientDHNonce = tmpClientDHNonce;
                }
                else
                {
                    decoded.ClientDHNonce = explicitReader.ReadOctetString();
                }
                explicitReader.ThrowIfNotEmpty();
            }

            sequenceReader.ThrowIfNotEmpty();
        }
    }
}
