---
title: "ASP.NET Core docs: What's new for April 2024"
description: "What's new in the ASP.NET Core docs for April 2024."
ms.custom: April-2024
ms.date: 05/01/2024
---

# ASP.NET Core docs: What's new for April 2024

Welcome to what's new in the ASP.NET Core docs for April 2024. This article lists some of the major changes to docs during this period.

## Blazor

### New articles

- <xref:blazor/host-and-deploy/webassembly-caching/index>
- <xref:blazor/tooling/webassembly>
- <xref:blazor/security/qrcodes-for-authenticator-apps>
- <xref:blazor/js-interop/javascript-location>

### Updated articles

- <xref:blazor/components/quickgrid> - Update QuickGrid guidance
- <xref:blazor/fundamentals/configuration> - Improve guidance on security config with app settings files
- <xref:blazor/forms/index>
  - Clear forms and fields
  - Improve @formname coverage
- <xref:blazor/globalization-localization> - [Blazor] Globalization & localization - correct async JS interop
- <xref:blazor/hosting-models> - Blazor WASM build tools + AOT article
- <xref:blazor/js-interop/ssr> - QR code generation article for BWAs
- <xref:blazor/fundamentals/logging> - [Blazor] Logging - comments for "magic numbers"
- <xref:blazor/fundamentals/routing> - Guidance on dynamic NavLink generation
- <xref:blazor/fundamentals/signalr>
  - Revise content on the reconnection UI delay
  - Improve SignalR connection guidance
- <xref:blazor/components/templated-components> - [Blazor] Templated components - TemplatedNavBar + keyed TableTemplate
- <xref:blazor/webassembly-native-dependencies> - Blazor WASM build tools + AOT article
- <xref:blazor/components/generic-type-support> - Generic type article improvements
- <xref:blazor/components/lifecycle>
  - Improve lifecycle method remarks
  - Revise setting parameters lifecycle remarks
  - Improve `SetParametersAsync` base method coverage
- <xref:blazor/components/virtualization> - [Blazor] Virtualization - data slicing clarification
- <xref:blazor/components/index>
  - Clarify conditional HTML element attributes
  - Distinguish Razor components
- <xref:blazor/js-interop/call-dotnet-from-javascript> - Dedicated article on JS location
- <xref:blazor/js-interop/call-javascript-from-dotnet> - Dedicated article on JS location
- <xref:blazor/debug> - Add Debugger support section
- <xref:blazor/components/dynamiccomponent> - [Blazor] DynamicComponents - fixes samples vulnerability + related adjustments
- <xref:blazor/host-and-deploy/webassembly>
  - Blazor WASM build tools + AOT article
  - WASM runtime max heap size
- <xref:blazor/host-and-deploy/server>
  - Improve IIS crosslinking and additional deployment updates
  - Blazor WASM build tools + AOT article
  - Memory management updates
  - Improve SignalR connection guidance
- <xref:blazor/security/webassembly/meid-groups-roles> - Add additional scope guidance
- <xref:blazor/security/blazor-web-app-oidc>
  - OIDC Blazor authentication text improvements
  - Clarify use of IHttpContextAccessor/HttpContext
- <xref:blazor/security/index> - Shorten class name

## Fundamentals

### Updated articles

- <xref:fundamentals/error-handling> - .NET 9 endpoint metadata on error handling page
- <xref:fundamentals/minimal-apis/responses>
  - .NET 9 moniker prep for 500 status code TypedResults
  - Update not-latest and not-current include files
  - .NET 9 new feature - Internal Server Error TypedResults on Responses page
- <xref:fundamentals/minimal-apis/handle-errors> - Update not-latest and not-current include files
- <xref:fundamentals/openapi/aspnetcore-openapi>
  - No swag
  - Mon prep
- <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg013> - fix RDG highlights after code samples update
- <xref:fundamentals/websockets> - Refresh my top 10 topics: WebSockets

## gRPC

### Updated articles

- <xref:grpc/performance> - Add docs for WinHttpHandler and multiple connections
- <xref:grpc/test-tools> - Test gRPC: Update API test Tooling

## Hosting and deployment

### Updated articles

- <xref:host-and-deploy/proxy-load-balancer> - Fix documentation about how X-Original-* headers are populated

## Mobile development

### Updated articles

- <xref:mobile/native-mobile-backend> - Native Mobile Backend.

## MVC

### Updated articles

- <xref:mvc/advanced/custom-model-binding> - Update API test tool: Custom Model Binding
- <xref:mvc/views/razor> - Improve @formname coverage
- <xref:mvc/views/working-with-forms> - fix highlight and style in snippets

## Release notes

### Updated articles

- <xref:aspnetcore-9> - .NET 9 - endpoint metadata on what's new

## Security

### Updated articles

- <xref:security/authentication/identity-enable-qrcodes> - QR code generation article for BWAs
- <xref:security/authentication/mfa> - Moniker prep for .NET 9 content

## SignalR

### Updated articles

- <xref:signalr/groups> - SignalR: Clarify groups

## Tutorials

### Updated articles

- <xref:tutorials/first-mongo-app> - WebAPI MongoDB: Clarify steps
- <xref:tutorials/get-started-with-swashbuckle>
  - Swagger Update: web-api-help-pages: Sample fix
  - fix Swag
  - Doc With Swagger: Enable only in dev env

## Community contributors

The following people contributed to the ASP.NET Core docs during this period. Thank you! Learn how to contribute by following the links under "Get involved" in the [what's new landing page](index.yml).

- [hakenr](https://github.com/hakenr) - Robert Haken ![10 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-10-green)
- [timdeschryver](https://github.com/timdeschryver) - Tim Deschryver ![5 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-5-green)
- [damienbod](https://github.com/damienbod) - damienbod ![2 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-2-green)
- [sousadiego11](https://github.com/sousadiego11) - Diego Sousa ![2 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-2-green)
- [andriibratanin](https://github.com/andriibratanin) - Andrii Bratanin ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [ceddy4395](https://github.com/ceddy4395) - Cedric  ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [joegoldman2](https://github.com/joegoldman2) -  ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [ndc](https://github.com/ndc) - Endy Tjahjono ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [PawelAdamczuk](https://github.com/PawelAdamczuk) - Paweł Adamczuk ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [plasmarocker](https://github.com/plasmarocker) - Jonathan Carter ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
