---
title: "ASP.NET Core docs: What's new for February 2024"
description: "What's new in the ASP.NET Core docs for February 2024."
ms.custom: February-2024
ms.date: 03/01/2024
---

# ASP.NET Core docs: What's new for February 2024

Welcome to what's new in the ASP.NET Core docs for February 2024. This article lists some of the major changes to docs during this period.

## Miscellaneous


## Blazor

### New articles

- <xref:blazor/security/blazor-web-app-oidc>

### Updated articles

- <xref:blazor/security/blazor-web-app-oidc>
  - Blazor troubleshooting guidance updates
  - Redirect to the home page
  - Blazor Web App with OIDC article
- <xref:blazor/components/quickgrid> - Add QuickGrid API cross-links
- <xref:blazor/fundamentals/dependency-injection>
  - Ctor service injection
  - Services via the top-level imports file
  - Clarify "subset" of .NET API remark
  - Transient "disposable" service language updates
  - Cross-link (don't show) example code
  - Update transient services guidance
- <xref:blazor/components/lifecycle>
  - Move handle errors section
  - Lifecycle methods call ordering
- <xref:blazor/components/sync-context>
  - Move handle errors section
  - Blazor Synchronization contxt - draw sample code
- <xref:blazor/fundamentals/handle-errors>
  - Move handle errors section
  - Update DispatchExceptionAsync example
  - Update render mode guidance for error boundaries
- <xref:blazor/hybrid/routing> - Update deep linking guidance
- <xref:blazor/forms/binding> - Inline form updates for conventions
- <xref:blazor/forms/index> - Inline form updates for conventions
- <xref:blazor/fundamentals/routing>
  - Inline form updates for conventions
  - Routing - use @key in NavLink loop warning (instead of NavLink href)
  - Avoid referring to components or RenderFragment parameters as "tags"
- <xref:blazor/webassembly-lazy-load-assemblies> - Inline form updates for conventions
- <xref:blazor/components/render-modes> - Services via the top-level imports file
- <xref:blazor/components/index>
  - Update component ref text and examples
  - Update Route params section
- <xref:blazor/tutorials/build-a-blazor-app> - Update Todo component
- <xref:blazor/fundamentals/startup>
  - Add WebAssembly (runtime) startup callbacks
  - Blazor Startup - sample environment variable name
  - Startup - manually start Standalone Blazor WebAssembly
- <xref:blazor/security/webassembly/standalone-with-identity/index> - Add roles and test user guidance
- <xref:blazor/fundamentals/signalr> - [Blazor] SignalR - remove "using System" reminder
- <xref:blazor/hybrid/class-libraries> - Update 'Blazor Server' references
- <xref:blazor/host-and-deploy/webassembly>
  - Update "ASP.NET Core" references
  - Clarify "subset" of .NET API remark
- <xref:blazor/fundamentals/index> - Clarify "subset" of .NET API remark
- <xref:blazor/fundamentals/environments> - Improve Blazor Environments article
- <xref:blazor/globalization-localization> - Include a VSC path for resource files
- <xref:blazor/js-interop/call-dotnet-from-javascript> - Offline discussion updates for 8.0
- <xref:blazor/js-interop/call-javascript-from-dotnet> - Offline discussion updates for 8.0
- <xref:blazor/js-interop/index> - Offline discussion updates for 8.0
- <xref:blazor/security/webassembly/additional-scenarios> - Offline discussion updates for 8.0
- <xref:blazor/security/webassembly/index> - Offline discussion updates for 8.0
- <xref:blazor/components/built-in-components> - Revise built-in components list
- <xref:blazor/project-structure> - Revise built-in components list
- <xref:blazor/security/index>
  - Add a remarks on ClaimsPrincipal use
  - Avoid referring to components or RenderFragment parameters as "tags"
- <xref:blazor/debug>
  - Debugging article updates
  - Final round of debugging updates
  - Debug article follow-up 8.0
- <xref:blazor/fundamentals/static-files> - Document Static Web Asset Project Mode

## Client-side development

### Updated articles

- <xref:client-side/using-browserlink> - Moniker prep

## Fundamentals

### Updated articles

- <xref:fundamentals/minimal-apis/middleware> - Middleware in Minimal API: Add links
- <xref:fundamentals/native-aot-tutorial> - Update to Native capitalization
- <xref:fundamentals/aot/rdg> - Update to Native capitalization
- <xref:fundamentals/native-aot> - Update to Native capitalization
- <xref:fundamentals/minimal-apis> - filters
- <xref:fundamentals/logging/index> - Remove generic host
- <xref:fundamentals/localization/select-language-culture> - RouteDataRequestCultureProvider /8

## gRPC

### Updated articles

- <xref:grpc/native-aot> - Update to Native capitalization

## Migration

### New articles

- <xref:migration/80-to-90>

### Updated articles

- <xref:migration/70-to-80>
  - Add step to hosted Blazor WASM migration guidance
  - Update hosted WASM-to-BWA guidance
- <xref:migration/80-to-90>
  - migration to 9
  - Blazor What's New guidance

## Performance

### Updated articles

- <xref:performance/rate-limit> - Update rate-limit.md

## Razor Pages

### Updated articles

- <xref:razor-pages/ui-class> - RCL, adding static web assets

## Release notes

### New articles

- <xref:aspnetcore-9>

### Updated articles

- <xref:aspnetcore-9>
  - .NET 9 Preview 1
  - Blazor What's New guidance
  - What's new in ASP.NET Core 9.0 stub
- <xref:aspnetcore-8> - Update to Native capitalization

## Security

### Updated articles

- <xref:security/app-secrets> - Manually set assembly info attribute
- <xref:security/authentication/individual> - Note that Entra External ID tenants also use SingleOrg for --auth option
- <xref:security/authentication/index> - Blazor Web App with OIDC article
- <xref:security/authentication/certauth> - Add ChainTrustValidationMode and CustomTrustStore properties to certauth.md

## SignalR

### Updated articles

- <xref:signalr/security> - SignaR Security: Point to customizing CORS middleware
- <xref:signalr/redis-backplane>
  - SignalR Redis Backplane update and fix
  - SignalR: Redis Backplane: Change to include versioning

## Testing

### Updated articles

- <xref:test/integration-tests>
  - remove deprecated ISystemClock
  - Explain integration test  WebHostBuilderSection

## Tutorials

### Updated articles

- <xref:tutorials/min-web-api> - Min Web API tutorial: Remove prerelease for packages
- <xref:tutorials/first-mvc-app/adding-model> - VSC improvements for Razor Pages and MVC Tutorials
- <xref:tutorials/first-mvc-app/new-field> - VSC improvements for Razor Pages and MVC Tutorials
- <xref:tutorials/first-mvc-app/start-mvc> - VSC improvements for Razor Pages and MVC Tutorials
- <xref:tutorials/razor-pages/model> - VSC improvements for Razor Pages and MVC Tutorials
- <xref:tutorials/razor-pages/new-field> - VSC improvements for Razor Pages and MVC Tutorials
- <xref:tutorials/razor-pages/razor-pages-start> - VSC improvements for Razor Pages and MVC Tutorials
- <xref:tutorials/web-api-help-pages-using-swagger> - Update getting-started-with-swashbuckle.md
- <xref:tutorials/get-started-with-swashbuckle>
  - Improve description of the UseSwaggerUI method
  - Update getting-started-with-swashbuckle.md
- <xref:tutorials/razor-pages/validation>
  - Razor Pages Get Started: Fix VS Code and MacOS explanation for Up
  - edit validation.md: use `dotnet ef database update` in Visual Studio Code section. Use `Update-Database` in Visual Studio section
- <xref:tutorials/razor-pages/search> - edit search.md: in Note that describes LINQ Contains and SQLite case (in)sensitivity, include links in the Note instead of outside

## Community contributors

The following people contributed to the ASP.NET Core docs during this period. Thank you! Learn how to contribute by following the links under "Get involved" in the [what's new landing page](index.yml).

- [hakenr](https://github.com/hakenr) - Robert Haken ![17 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-17-green)
- [stanimirovv](https://github.com/stanimirovv) - Zlatin Stanimirov ![6 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-6-green)
- [yogyogi](https://github.com/yogyogi) - Yogi ![4 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-4-green)
- [zipperer](https://github.com/zipperer) - Andrew Zipperer ![3 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-3-green)
- [timdeschryver](https://github.com/timdeschryver) - Tim Deschryver ![2 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-2-green)
- [0xced](https://github.com/0xced) - Cédric Luthi ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [andrerom](https://github.com/andrerom) - André R. ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [aterbo](https://github.com/aterbo) - aterbo ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [Burke-Chris](https://github.com/Burke-Chris) -  ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [CadeMH](https://github.com/CadeMH) - Cade ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [damienbod](https://github.com/damienbod) - damienbod ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [edwardneal](https://github.com/edwardneal) - Edward Neal ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [ilmalte](https://github.com/ilmalte) - Daniele Maltese ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [jufa2401](https://github.com/jufa2401) - Justin Fabricius ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [StormPooper](https://github.com/StormPooper) - Daniel Smith ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
- [thabaum](https://github.com/thabaum) - Cody ![1 pull requests.](https://img.shields.io/badge/Merged%20Pull%20Requests-1-green)
