---
title: "Tutorial: Create a Razor Pages web app with ASP.NET Core"
author: wadepickett
description: This series of tutorials explains the basics of building a Razor Pages web app. 
ms.author: wpickett
ms.date: 06/23/2024
monikerRange: '>= aspnetcore-3.1'
uid: tutorials/razor-pages/index
---
# Tutorial: Create a Razor Pages web app with ASP.NET Core

[!INCLUDE[](~/includes/not-latest-version.md)]

This series of tutorials explains the basics of building a Razor Pages web app.

For a more advanced introduction aimed at developers who are familiar with controllers and views, see <xref:razor-pages/index>.

[!INCLUDE [Choose web UI](~/includes/choose-ui-link.md)]

This series includes the following tutorials:

1. [Create a Razor Pages web app](xref:tutorials/razor-pages/razor-pages-start)
1. [Add a model to a Razor Pages app](xref:tutorials/razor-pages/model)
1. [Scaffold (generate) Razor pages](xref:tutorials/razor-pages/page)
1. [Work with a database](xref:tutorials/razor-pages/sql)
1. [Update Razor pages](xref:tutorials/razor-pages/da1)
1. [Add search](xref:tutorials/razor-pages/search)
1. [Add a new field](xref:tutorials/razor-pages/new-field)
1. [Add validation](xref:tutorials/razor-pages/validation)

At the end, you'll have an app that can display and manage a database of movies.

![Sample page of sample app](~/tutorials/razor-pages/index/_static/sample-page.png)

![Sample edit validation of sample app](~/tutorials/razor-pages/index/_static/sample-page-validation.png)
