---
title: Community OSS authentication options for ASP.NET Core
author: rick-anderson
description: Discover open-source authentication options for ASP.NET Core.
ms.author: riande
ms.date: 05/01/2024
uid: security/authentication/community
---
# Community OSS authentication options for ASP.NET Core

This page shows community-provided [open-source software (OSS)](https://en.wikipedia.org/wiki/Open-source_software) authentication options for ASP.NET Core. This page is periodically updated as new providers become available.

## OSS authentication providers [.NET]

| Name | Description |
| ---- | ----------- |
| [Duende IdentityServer](https://duendesoftware.com/products/identityserver) | IdentityServer is an OpenID Connect and OAuth 2.0 framework for ASP.NET Core. |
| [OpenIddict](https://github.com/openiddict/openiddict-core) | OAuth 2.0/OpenID Connect server for ASP.NET Core and ASP.NET 4.x. |
| [FIDO2 .NET Library, WebAuthn](https://github.com/passwordless-lib/fido2-net-lib) | FIDO2 .NET library for FIDO2 / WebAuthn Attestation and Assertion using .NET |

## OSS authentication provider clients [.NET]

| Name | Description |
| ---- | ----------- |
| [OpenIddict](https://github.com/openiddict/openiddict-core) | OAuth 2.0/OpenID Connect client for ASP.NET Core, ASP.NET 4.x and Windows/Linux desktop apps with built-in integrations for 80+ services such as Auth0, Microsoft Entra ID, GitHub, Google, Twitter or Yahoo. |
| [AspNet.Security.OAuth.Providers](https://github.com/aspnet-contrib/AspNet.Security.OAuth.Providers)  | A collection of security middleware for ASP.NET Core apps to support social authentication. |
| [AspNet.Security.OpenId.Providers](https://github.com/aspnet-contrib/AspNet.Security.OpenId.Providers) | A collection of security middleware for ASP.NET Core apps to support OpenID 2.0 authentication providers like [Steam](https://steampowered.com/). |

## Other OSS authentication providers 

| Name | Description |
| ---- | ----------- |
| [Gluu Server](https://gluu.org/) | Enterprise ready, open source software for identity, access management (IAM), and single sign-on (SSO). For more information, see the [Gluu Product Documentation](https://gluu.org/docs/). |
| [Keycloak](https://github.com/keycloak/keycloak/) | Open Source Identity and Access Management For Modern Applications and Services. |
| [node-oidc-provider](https://github.com/panva/node-oidc-provider) | OpenID Certified™ OAuth 2.0 Authorization Server implementation for Node.js. |
| [Authentik](https://goauthentik.io)| Authentik is an open-source Identity Provider focused on flexibility and versatility. |
  
To add a provider, [edit this page](https://github.com/login?return_to=https%3A%2F%2Fgithub.com%2Fdotnet%2FAspNetCore.Docs%2Fedit%2Fmain%2Faspnetcore%2Fsecurity%2Fauthentication%2Fcommunity.md).
