---
title: Microsoft identity platform and Microsoft Entra ID with ASP.NET Core
author: rick-anderson
description: Discover topics related to authentication with Microsoft identity platform Microsoft Entra ID for web apps and APIs in ASP.NET Core.
ms.author: riande
ms.date: 01/21/2020
ms.custom: mvc
uid: security/authentication/azure-active-directory/index
---
# Microsoft Entra ID with ASP.NET Core

These tutorials and samples demonstrate authentication in ASP.NET Core using Microsoft identity platform and Microsoft Entra ID. For additional tutorials and samples using ASP.NET Core with Azure AD, see [Microsoft identity platform](/azure/active-directory/develop/).

## Application Scenarios

* [Quickstart: Add sign-in with Microsoft to an ASP.NET Core web app](/azure/active-directory/develop/web-app-quickstart?pivots=devlang-aspnet-core&tabs=windows)
* [Web app that signs in users](/azure/active-directory/develop/scenario-web-app-sign-user-overview?tabs=aspnetcore)
* [Web app that calls web APIs](/azure/active-directory/develop/scenario-web-app-call-api-overview)
* [Protected web API](/azure/active-directory/develop/scenario-protected-web-api-overview)
* [Web API that calls other web APIs](/azure/active-directory/develop/scenario-web-api-call-api-overview)
* [Web app that signs in users with Azure AD B2C](xref:security/authentication/azure-ad-b2c) <!-- Azure AD B2C excluded -->

## Samples

* [Enable your ASP.NET Core app to sign-in users and call web APIs using Microsoft identity platform for developers](https://github.com/Azure-Samples/active-directory-aspnetcore-webapp-openidconnect-v2/)
