---
title: What's new in ASP.NET Core 9.0
author: rick-anderson
description: Learn about the new features in ASP.NET Core 9.0.
ms.author: riande
ms.custom: mvc
ms.date: 11/19/2024
uid: aspnetcore-9
---
# What's new in ASP.NET Core 9.0

This article highlights the most significant changes in ASP.NET Core 9.0 with links to relevant documentation.

## Static asset delivery optimization

[`MapStaticAssets` routing endpoint conventions](xref:Microsoft.AspNetCore.Builder.StaticAssetsEndpointRouteBuilderExtensions.MapStaticAssets%2A) is a new feature that optimizes the delivery of static assets in ASP.NET Core apps.

For information on static asset delivery for Blazor apps, see <xref:blazor/fundamentals/static-files?view=aspnetcore-9.0>.

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/web_asset_delivery.md)]

## Blazor

This section describes new features for Blazor.

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/blazor.md)]

## SignalR

This section describes new features for SignalR.

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/signalr.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/signalrActivities.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/signalr-trimming-aot.md)]

## Minimal APIs

This section describes new features for minimal APIs.

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/status500.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/produces-problem.md)]

## OpenAPI

This section describes new features for OpenAPI

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/openApi.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/openapi-aot.md)]

## Authentication and authorization

This section describes new features for authentication and authorization.

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/par.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/oidccustomparms.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/httpsysextendedauth.md)]

## Miscellaneous

The following sections describe miscellaneous new features.

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/hybrid-cache.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/endpoint-metadata.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/debugger.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/fix-for-503s.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/asp0026.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/improved-kestrel-connection-metrics.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/customize-named-pipes.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/exception-type-sets-http-status.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/opt_out_metrics.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/delete_keys.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/keyedDI.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/trust_dev_cert_linux.md)]

[!INCLUDE[](~/release-notes/aspnetcore-9/includes/updated-versions.md)]
