---
title: What's new in ASP.NET Core 1.1
author: rick-anderson
description: Learn about the new features in ASP.NET Core 1.1.
ms.author: riande
ms.date: 12/18/2018
uid: aspnetcore-1.1
---

# What's new in ASP.NET Core 1.1

ASP.NET Core 1.1 includes the following new features:

- [URL Rewriting Middleware](xref:fundamentals/url-rewriting)
- [Response Caching Middleware](xref:performance/caching/middleware)
- [View Components as Tag Helpers](xref:mvc/views/view-components#invoking-a-view-component-as-a-tag-helper)
- [Middleware as MVC filters](xref:mvc/controllers/filters#using-middleware-in-the-filter-pipeline)
- [Cookie-based TempData provider](xref:fundamentals/app-state#tempdata)
- [Azure App Service logging provider](xref:fundamentals/logging/index#azure-app-service)
- [Azure Key Vault configuration provider](xref:security/key-vault-configuration)
- [Azure and Redis Storage Data Protection Key Repositories](xref:security/data-protection/implementation/key-storage-providers)
- WebListener Server for Windows
- [WebSockets support](xref:fundamentals/websockets)

## Choosing between versions 1.0 and 1.1 of ASP.NET Core

ASP.NET Core 1.1 has more features than ASP.NET Core 1.0. In general, we recommend you use the latest version.

## Additional Information

- [ASP.NET Core 1.1.0 Release Notes](https://github.com/dotnet/aspnetcore/releases/tag/1.1.0)
- To connect with the ASP.NET Core development team's progress and plans, tune in to the [ASP.NET Community Standup](https://live.asp.net/).
