# ASP.NET Core Model Providers Sample

This sample illustrates use of Razor Pages custom route and page model providers. This sample demonstrates the features described in the [Razor Pages route and app conventions](https://learn.microsoft.com/aspnet/core/razor-pages/razor-pages-convention-features) topic.

## Examples in this sample

| Scenario | Sample demo |
| -------- | ----------- |
| [Model conventions](https://learn.microsoft.com/aspnet/core/razor-pages/razor-pages-conventions#model-conventions) | Add a route attribute and header to the app's pages. |
| [Use AddPageRoute to add a page route](https://learn.microsoft.com/aspnet/core/razor-pages/razor-pages-conventions#configure-a-page-route) | Adds the specified route to the page at the specified page. |
| [Page model action conventions](https://learn.microsoft.com/aspnet/core/razor-pages/razor-pages-conventions#page-model-action-conventions) | Add a header to pages in a folder, add a header to a single page, and configure a filter factory to add a header to the app's pages. |
| [Replace the default page app model provider](https://learn.microsoft.com/aspnet/core/razor-pages/razor-pages-conventions#replace-the-default-page-app-model-provider) | Change the conventions for handler naming. |
