using FiltersSample.Filters;
using FiltersSample.Helper;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;

namespace FiltersSample
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        // <snippet>
        public void ConfigureServices(IServiceCollection services)
        {
            // Add service filters.
            services.AddScoped<AddHeaderResultServiceFilter>();
            services.AddScoped<SampleActionFilterAttribute>();

            services.AddControllersWithViews(options =>
           {
               options.Filters.Add(new AddHeaderAttribute("GlobalAddHeader",
                   "Result filter added to MvcOptions.Filters"));         // An instance
                options.Filters.Add(typeof(MySampleActionFilter));         // By type
                options.Filters.Add(new SampleGlobalActionFilter());       // An instance
            });
        }
        // </snippet>

        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Home/Error");
                app.UseHsts();
            }
            app.UseHttpsRedirection();
            app.UseStaticFiles();

            app.UseRouting();

            app.UseAuthorization();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllerRoute(
                    name: "default",
                    pattern: "{controller=Home}/{action=Index}/{id?}");
            });
        }
    }
}
