---
title: Migrate from Microsoft.Extensions.Logging 2.1 to 2.2 or 3.0
author: rick-anderson
description: Learn how to migrate a non-ASP.NET Core application that uses Microsoft.Extensions.Logging from 2.1 to 2.2 or 3.0.
ms.author: riande
ms.custom: mvc
ms.date: 01/04/2019
uid: migration/logging-nonaspnetcore
---

# Migrate from Microsoft.Extensions.Logging 2.1 to 2.2 or 3.0

This article outlines the common steps for migrating a non-ASP.NET Core application that uses `Microsoft.Extensions.Logging` from 2.1 to 2.2 or 3.0.

## 2.1 to 2.2

Manually create `ServiceCollection` and call `AddLogging`.

2.1 example:

```csharp
using (var loggerFactory = new LoggerFactory())
{
    loggerFactory.AddConsole();

    // use loggerFactory
}
```

2.2 example:

```csharp
var serviceCollection = new ServiceCollection();
serviceCollection.AddLogging(builder => builder.AddConsole());

using (var serviceProvider = serviceCollection.BuildServiceProvider())
using (var loggerFactory = serviceProvider.GetService<ILoggerFactory>())
{
    // use loggerFactory
}
```

## 2.1 to 3.0

In 3.0, use `LoggingFactory.Create`.

2.1 example:

```csharp
using (var loggerFactory = new LoggerFactory())
{
    loggerFactory.AddConsole();

    // use loggerFactory
}
```

3.0 example:

```csharp
using (var loggerFactory = LoggerFactory.Create(builder => builder.AddConsole()))
{
    // use loggerFactory
}
```

## Additional resources

* [Microsoft.Extensions.Logging.Console NuGet package](https://www.nuget.org/packages/Microsoft.Extensions.Logging.Console/).
* <xref:fundamentals/logging/index>
