---
title: Migrate from ASP.NET Core 3.0 to 3.1
author: rick-anderson
description: Learn how to migrate an ASP.NET Core 3.0 project to ASP.NET Core 3.1.
ms.author: wpickett
ms.custom: mvc
ms.date: 07/02/2020
uid: migration/30-to-31
---
# Migrate from ASP.NET Core 3.0 to 3.1

By [Scott Addie](https://github.com/scottaddie)

This article explains how to update an existing ASP.NET Core 3.0 project to ASP.NET Core 3.1.

## Prerequisites

# [Visual Studio](#tab/visual-studio)

[!INCLUDE[](~/includes/net-core-prereqs-vs-3.1.md)]

# [Visual Studio Code](#tab/visual-studio-code)

[!INCLUDE[](~/includes/net-core-prereqs-vsc-3.1.md)]

# [Visual Studio for Mac](#tab/visual-studio-mac)

[!INCLUDE[](~/includes/net-core-prereqs-mac-3.1.md)]

---

## Update .NET Core SDK version in global.json

If you rely upon a [global.json](/dotnet/core/tools/global-json) file to target a specific .NET Core SDK version, update the `version` property to the 3.1 SDK version that's installed. For example:

```diff
{
  "sdk": {
-    "version": "3.0.101"
+    "version": "3.1.101"
  }
}
```

## Update the target framework

In the project file, update the [Target Framework Moniker (TFM)](/dotnet/standard/frameworks) to `netcoreapp3.1`:

```diff
<Project Sdk="Microsoft.NET.Sdk.Web">

  <PropertyGroup>
-    <TargetFramework>netcoreapp3.0</TargetFramework>
+    <TargetFramework>netcoreapp3.1</TargetFramework>
  </PropertyGroup>

</Project>
```

## Update package references

In the project file, update each `Microsoft.AspNetCore.*` package reference's `Version` attribute to 3.1.0 or later. For example:

```diff
<ItemGroup>
-    <PackageReference Include="Microsoft.AspNetCore.Mvc.NewtonsoftJson" Version="3.0.0" />
-    <PackageReference Include="Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation" Version="3.0.0" Condition="'$(Configuration)' == 'Debug'" />
+    <PackageReference Include="Microsoft.AspNetCore.Mvc.NewtonsoftJson" Version="3.1.1" />
+    <PackageReference Include="Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation" Version="3.1.1" Condition="'$(Configuration)' == 'Debug'" />
</ItemGroup>
```

## Update Docker images

For apps using Docker, use a base image that includes ASP.NET Core 3.1. For example:

```console
docker pull mcr.microsoft.com/dotnet/aspnet:3.1
```

## React to SameSite cookie changes

The `SameSite` attribute implementations for HTTP cookies changed between ASP.NET Core 3.0 and 3.1. For actions to be taken, see the following resources:

* <xref:security/samesite>
* [aspnet/Announcements#390](https://github.com/aspnet/Announcements/issues/390)
* [Upcoming SameSite cookie changes in ASP.NET and ASP.NET Core](https://devblogs.microsoft.com/aspnet/upcoming-samesite-cookie-changes-in-asp-net-and-asp-net-core/)

## Publish with Visual Studio

In the `.pubxml` file update the `TargetFramework` to 3.1:

```xml
- <TargetFramework>netcoreapp3.0</TargetFramework>
+ <TargetFramework>netcoreapp3.1</TargetFramework>
```

## Review breaking changes

Review 3.0-to-3.1 breaking changes across .NET Core, ASP.NET Core, and Entity Framework Core at [Breaking changes for migration from version 3.0 to 3.1](/dotnet/core/compatibility/3.0-3.1).

## Optional changes

The following changes are optional.

### Use the Component Tag Helper

ASP.NET Core 3.1 introduces a `Component` Tag Helper. The Tag Helper can replace the `RenderComponentAsync<TComponent>` HTML helper method in a Blazor project. For example:

```diff
- @(await Html.RenderComponentAsync<Counter>(RenderMode.ServerPrerendered, new { IncrementAmount = 10 }))
+ <component type="typeof(Counter)" render-mode="ServerPrerendered" param-IncrementAmount="10" />
```

For more information, see <xref:blazor/components/integration?view=aspnetcore-3.1&preserve-view=true>.

## ASP.NET Core Module (ANCM)

[!INCLUDE[](~/includes/hosting-bundle.md)]
