---
author: tdykstra
ms.author: tdykstra
ms.date: 09/12/2023
ms.topic: include
---
## ASP.NET Core SPA templates

Visual Studio includes templates for building ASP.NET Core apps with a JavaScript or TypeScript frontend. These templates are available in Visual Studio 2022 version 17.8 or later with the **ASP.NET and web development** workload installed.

The Visual Studio templates for building ASP.NET Core apps with a JavaScript or TypeScript frontend offer the following benefits:

* Clean project separation for the frontend and backend.
* Stay up-to-date with the latest frontend framework versions.
* Integrate with the latest frontend framework command-line tooling, such as [Vite](https://vitejs.dev/).
* Templates for both JavaScript & TypeScript (only TypeScript for Angular).
* Rich JavaScript and TypeScript code editing experience.
* Integrate JavaScript build tools with the .NET build.
* npm dependency management UI.
* Compatible with Visual Studio Code debugging and launch configuration.
* Run frontend unit tests in [Test Explorer](/visualstudio/test/run-unit-tests-with-test-explorer) using JavaScript test frameworks.

## Legacy ASP.NET Core SPA templates

Earlier versions of the .NET SDK included what are now legacy templates for building SPA apps with ASP.NET Core. For documentation on these older templates, see the ASP.NET Core 7.0 version of the [SPA overview](xref:spa/intro?view=aspnetcore-7.0&preserve-view=true) and the [Angular](xref:spa/angular?view=aspnetcore-7.0&preserve-view=true&tabs=net-cli) and [React](xref:spa/react?view=aspnetcore-7.0&preserve-view=true&tabs=net-cli) articles.
