ASP.NET Core provides the following benefits:

* A unified story for building web UI and web APIs.
* Architected for testability.
* [Razor Pages](xref:razor-pages/index) makes coding page-focused scenarios easier and more productive.
* [Blazor](xref:blazor/index) lets you use C# in the browser alongside JavaScript. Share server-side and client-side app logic all written with .NET.
* Ability to develop and run on Windows, macOS, and Linux.
* Open-source and [community-focused](https://live.asp.net/).
* Integration of [modern, client-side frameworks](xref:blazor/index) and development workflows.
* Support for hosting Remote Procedure Call (RPC) services using [gRPC](xref:grpc/index).
* A cloud-ready, environment-based [configuration system](xref:fundamentals/configuration/index).
* Built-in [dependency injection](xref:fundamentals/dependency-injection).
* A lightweight, [high-performance](https://github.com/aspnet/benchmarks), and modular HTTP request pipeline.
* Ability to host on the following:
  * [Kestrel](xref:fundamentals/servers/kestrel)
  * [IIS](xref:host-and-deploy/iis/index)
  * [HTTP.sys](xref:fundamentals/servers/httpsys)
  * [Nginx](xref:host-and-deploy/linux-nginx)
  * [Docker](xref:host-and-deploy/docker/index)
* [Side-by-side versioning](/dotnet/standard/choosing-core-framework-server#side-by-side-net-versions-per-application-level).
* Tooling that simplifies modern web development.
