:::moniker range="= aspnetcore-7.0"
## `WebApplication`

The following code is generated by an ASP.NET Core template:

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_default)]

The preceding code can be created via `dotnet new web` on the command line or selecting the Empty Web template in Visual Studio.

The following code creates a <xref:Microsoft.AspNetCore.Builder.WebApplication> (`app`) without explicitly creating a <xref:Microsoft.AspNetCore.Builder.WebApplicationBuilder>:

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_create)]

[`WebApplication.Create`](xref:Microsoft.AspNetCore.Builder.WebApplication.Create%2A) initializes a new instance of the <xref:Microsoft.AspNetCore.Builder.WebApplication> class with preconfigured defaults.

[!INCLUDE [webapplication7](~/fundamentals/minimal-apis/includes/middleware7.md)]

### Working with ports

When a web app is created with Visual Studio or `dotnet new`, a `Properties/launchSettings.json` file is created that specifies the ports the app responds to. In the port setting samples that follow, running the app from Visual Studio returns an error dialog `Unable to connect to web server 'AppName'`.  Visual Studio returns an error because it's expecting the port specified in `Properties/launchSettings.json`, but the app is using the port specified by `app.Run("http://localhost:3000")`. Run the following port changing samples from the command line.

The following sections set the port the app responds to.

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_p1)]

In the preceding code, the app responds to port `3000`.

#### Multiple ports

In the following code, the app responds to port `3000` and `4000`.

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_pm)]

#### Set the port from the command line

The following command makes the app respond to port `7777`:

```dotnetcli
dotnet run --urls="https://localhost:7777"
```

If the Kestrel endpoint is also configured in the `appsettings.json` file, the `appsettings.json` file specified URL is used. For more information, see [Kestrel endpoint configuration](xref:fundamentals/configuration/index#kestrel)

#### Read the port from environment

The following code reads the port from the environment:

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_pe)]

The preferred way to set the port from the environment is to use the `ASPNETCORE_URLS` environment variable, which is shown in the following section.

#### Set the ports via the ASPNETCORE_URLS environment variable

The `ASPNETCORE_URLS` environment variable is available to set the port:

```
ASPNETCORE_URLS=http://localhost:3000
```

`ASPNETCORE_URLS` supports multiple URLs:

```
ASPNETCORE_URLS=http://localhost:3000;https://localhost:5000
```

For more information using the environment, see <xref:fundamentals/environments>

### Listen on all interfaces

The following samples demonstrate listening on all interfaces

#### http://*:3000

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_i1)]

#### http://+:3000

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_ip)]

#### `http://0.0.0.0:3000`

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_i0)]

### Listen on all interfaces using ASPNETCORE_URLS

The preceding samples can use `ASPNETCORE_URLS`

```
ASPNETCORE_URLS=http://*:3000;https://+:5000;http://0.0.0.0:5005
```

### Specify HTTPS with development certificate

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_cert)]

For more information on the development certificate, see [Trust the ASP.NET Core HTTPS development certificate on Windows and macOS](xref:security/enforcing-ssl#trust).

### Specify HTTPS using a custom certificate

The following sections show how to specify the custom certificate using the `appsettings.json` file and via configuration.

#### Specify the custom certificate with `appsettings.json`

[!code-json[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/appsettingsCert.json?highlight=9-16)]

#### Specify the custom certificate via configuration

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_cert2)]

#### Use the certificate APIs

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_cert3)]

### Configuration

The following code reads from the configuration system:

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_CONFIG)]

For more information, see <xref:fundamentals/configuration/index>

### Logging

The following code writes a message to the log on application startup:

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_log)]

For more information, see <xref:fundamentals/logging/index>

### Access the Dependency Injection (DI) container

The following code shows how to get services from the DI container during application startup:

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_dependencies)]

For more information, see <xref:fundamentals/dependency-injection>.

## WebApplicationBuilder

This section contains sample code using <xref:Microsoft.AspNetCore.Builder.WebApplicationBuilder>.

### Change the content root, application name, and environment

The following code sets the content root, application name, and environment:

[!code-csharp[](~/migration/50-to-60-samples/samples/Web6Samples/Program.cs?name=snippet_root)]

[WebApplication.CreateBuilder](xref:Microsoft.AspNetCore.Builder.WebApplication.CreateBuilder%2A) initializes a new instance of the <xref:Microsoft.AspNetCore.Builder.WebApplicationBuilder> class with preconfigured defaults.

For more information, see <xref:fundamentals/index>

### Change the content root, app name, and environment by environment variables or command line

The following table shows the environment variable and command-line argument used to change the content root, app name, and environment:

| feature   | Environment variable | Command-line argument |
| ------------- | ------------- | -- |
| Application name | ASPNETCORE_APPLICATIONNAME  | --applicationName |
| Environment name |  ASPNETCORE_ENVIRONMENT | --environment |
| Content root  | ASPNETCORE_CONTENTROOT  | --contentRoot |

### Add configuration providers

The following sample adds the INI configuration provider:

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Configuration.AddIniFile("appsettings.ini");

var app = builder.Build();
```

<!-- Duplicate sample in 50-to-60-samples doc. Once PR #23461 (Migrate to .NET 6 ) merges, remove this comment so the snippet is displayed 
[!code-csharp[](~/migration/50-to-60-samples/samples/Web6Samples/Program.cs?name=snippet_conf)]
-->

For detailed information, see [File configuration providers](xref:fundamentals/configuration/index#file-configuration-provider) in <xref:fundamentals/configuration/index>.

### Read configuration

By default the <xref:Microsoft.AspNetCore.Builder.WebApplicationBuilder> reads configuration from multiple sources, including:

* `appSettings.json` and `appSettings.{environment}.json`
* Environment variables
* The command line

The following code reads `HelloKey` from configuration and displays the value at the `/` endpoint. If the configuration value is null, "Hello" is assigned to `message`:

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_configb)]

For a complete list of configuration sources read, see [Default configuration](xref:fundamentals/configuration/index#default-configuration) in <xref:fundamentals/configuration/index>

### Add logging providers

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_logb)]

### Add services

[!code-csharp[](~/migration/50-to-60-samples/samples/Web6Samples/Program.cs?name=snippet_svc)]

### Customize the IHostBuilder

Existing extension methods on <xref:Microsoft.Extensions.Hosting.IHostBuilder> can be accessed using the [Host property](xref:Microsoft.Extensions.Hosting.IHostBuilder.Properties):

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_ihb)]

### Customize the IWebHostBuilder

Extension methods on <xref:Microsoft.AspNetCore.Hosting.IWebHostBuilder> can be accessed using the [WebApplicationBuilder.WebHost](xref:Microsoft.AspNetCore.Builder.WebApplicationBuilder.WebHost) property.

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_iwhb)]

### Change the web root

By default, the web root is relative to the content root in the `wwwroot` folder. Web root is where the static files middleware looks for static files. Web root can be changed with `WebHostOptions`, the command line, or with the <xref:Microsoft.AspNetCore.Hosting.HostingAbstractionsWebHostBuilderExtensions.UseWebRoot%2A> method:

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_chngr)]

### Custom dependency injection (DI) container

The following example uses [Autofac](https://autofac.readthedocs.io/en/latest/integration/aspnetcore.html):

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Host.UseServiceProviderFactory(new AutofacServiceProviderFactory());

// Register services directly with Autofac here. Don't
// call builder.Populate(), that happens in AutofacServiceProviderFactory.
builder.Host.ConfigureContainer<ContainerBuilder>(builder => builder.RegisterModule(new MyApplicationModule()));

var app = builder.Build();
```

### Add Middleware

Any existing ASP.NET Core middleware can be configured on the `WebApplication`:

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_addmid)]

For more information, see <xref:fundamentals/middleware/index>

### Developer exception page

<xref:Microsoft.AspNetCore.Builder.WebApplication.CreateBuilder%2A?displayProperty=nameWithType> initializes a new instance of the <xref:Microsoft.AspNetCore.Builder.WebApplicationBuilder> class with preconfigured defaults. The developer exception page is enabled in the  preconfigured defaults. When the following code is run in the [development environment](xref:fundamentals/environments), navigating to `/` renders a friendly page that shows the exception.

[!code-csharp[](~/fundamentals/minimal-apis/7.0-samples/WebMinAPIs/Program.cs?name=snippet_dep)]

:::moniker-end
