---
title: ASP.NET Core Request Delegate Generator (RDG) diagnostics
description: Provides a list of diagnostic emitted by the ASP.NET Core Request Delegate Generator (RDG) for Native AOT
author: rick-anderson
ms.author: riande
monikerRange: '>= aspnetcore-8.0'
content_well_notification: AI-contribution
ms.date: 9/23/2023
ms.topic: article
uid: fundamentals/aot/request-delegate-generator/rdg-ids
ai-usage: ai-assisted
---
# ASP.NET Core Request Delegate Generator (RDG) diagnostics

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

The ASP.NET Core Request Delegate Generator (RDG) is a tool that generates request delegates for ASP.NET Core apps. The RDG is used by the native ahead-of-time (AOT) compiler to generate request delegates for the app's `Map` methods.

[!INCLUDE[](~/fundamentals/aot/includes/aot_preview.md)]

The following list contains the [RDG diagnostics](https://source.dot.net/#Microsoft.AspNetCore.Http.RequestDelegateGenerator/DiagnosticDescriptors.cs,44128aef6daa9b5e) for ASP.NET Core:

<!--
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg001>
-->
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg002>
<!--
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg003>
-->
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg004>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg005>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg006>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg007>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg008>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg009>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg010>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg011>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg012>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg013>
<!--
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg014>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg015>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg016>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg017>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg018>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg019>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg020>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg021>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg022>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg023>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg024>
* <xref:fundamentals/aot/request-delegate-generator/diagnostics/rdg025> -->
