---
title: "RDG013: Invalid source attributes"
description: "Learn about analysis rule RDG013: Invalid source attributes"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
ms.author: safia
ms.date: 10/5/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg013
---
# RDG013: Invalid source attributes

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG013|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

This diagnostic is emitted by the [Request Delegate Generator](/aspnet/core/fundamentals/aot/request-delegate-generator/rdg) when an endpoint contains a route handler with a parameter that contains an invalid combination of service source attributes.

### Rule description

ASP.NET Core supports resolving keyed and non-keyed services via [dependency injection](xref:fundamentals/dependency-injection). It's ***not*** feasible to resolve a service as both keyed and non-keyed. The following code  produces the diagnostic and throws a run time error with the same message:

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg13/Program.cs" id="snippet_1" highlight="14":::

## How to fix violations

Resolve the target parameter as either a keyed or non-keyed service.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg13/Program.cs" id="snippet_1f" highlight="16,21,26":::

## When to suppress warnings

This warning should ***not*** be suppressed. Suppressing the warning leads to a [NotSupportedException](/dotnet/api/system.notsupportedexception) runtime exception `The FromKeyedServicesAttribute is not supported on parameters that are also annotated with IFromServiceMetadata.`
