---
title: "RDG012: Unable to resolve inaccessible type"
description: "Learn about analysis rule RDG012: Unable to resolve inaccessible type"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
ms.author: safia
ms.date: 09/15/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg012
---
# RDG012: Unable to resolve inaccessible type

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG012|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

This diagnostic is emitted by the Request Delegate Generator when an endpoint contains a route handler with a parameter without the appropriate accessibility modifiers.

### Rule description

Endpoints that use an inaccessible type (`private` or `protected`) are not supported. 
The endpoints within `MapEndpoints` produce this diagnostic because of the `Todo` type has the `private` accessibility modifiers.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg12/Program.cs" id="snippet_1" highlight="16-27, 29":::


## How to fix violations

When applicable, set the target parameter type with a friendly accessibility.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg12/Program.cs" id="snippet_1f" highlight="17-28, 30":::


## When to suppress warnings

This warning can be safely suppressed. When suppressed, the framework will fallback to generating the request delegate at runtime.
