---
title: "RDG011: Type parameters not supported"
description: "Learn about analysis rule RDG011: Type parameters not supported"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
ms.author: safia
ms.date: 09/15/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg011
---
# RDG011: Type parameters not supported

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG011|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

This diagnostic is emitted by the Request Delegate Generator when an endpoint contains a route handler that captures a generic type.

### Rule description

Endpoints that use generic type parameters are not supported. The endpoints within `MapEndpoints`  produce this diagnostic because of the generic `<T>` parameter.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg11/Program.cs" id="snippet_1" highlight="16":::

## How to fix violations

Remove the generic type from endpoints.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg11/Program.cs" id="snippet_1f" highlight="16":::

## When to suppress warnings

This warning can be safely suppressed. When suppressed, the framework will fallback to generating the request delegate at runtime.
