---
title: "RDG010:  InvalidAsParameters Nullable"
description: "Learn about analysis rule RDG010: InvalidAsParameters Nullable"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
ms.author: safia
ms.date: 09/15/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg010
---
# RDG010: InvalidAsParameters Nullable

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG010|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

This diagnostic is emitted by the [Request Delegate Generator](/aspnet/core/fundamentals/aot/request-delegate-generator/rdg) when an endpoint contains a route handler with a parameter annotated with the [`[AsParameters]`](xref:Microsoft.AspNetCore.Http.AsParametersAttribute) attribute that is marked as nullable.


### Rule description

The implementation of surrogate binding via the [`[AsParameters]`](xref:Microsoft.AspNetCore.Http.AsParametersAttribute) attribute in minimal APIs only supports types that are not nullable. 

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg10/Program.cs" id="snippet_1" highlight="13":::

## How to fix violations

Declare the parameter as non-nullable.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg10/Program.cs" id="snippet_1f" highlight="13":::

## When to suppress warnings

This warning should ***not*** be suppressed. Suppressing the warning leads to a runtime exception associated with the same warning.

