---
title: "RDG009: Invalid nested AsParameters"
description: "Learn about analysis rule RDG009: Invalid nested AsParameters"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
ms.author: safia
ms.date: 11/1/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg009
---
# RDG009: Invalid nested AsParameters

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG009|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

This diagnostic is emitted by the [Request Delegate Generator](/aspnet/core/fundamentals/aot/request-delegate-generator/rdg) when an endpoint contains invalid nested [`[AsParameters]`](xref:Microsoft.AspNetCore.Http.AsParametersAttribute).

### Rule description

Types that are used for surrogate binding via the  [`[AsParameters]`](xref:Microsoft.AspNetCore.Http.AsParametersAttribute) attribute must not contain nested types that are also annotated with the  [`[AsParameters]`](xref:Microsoft.AspNetCore.Http.AsParametersAttribute) attribute:

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg9/Program.cs" id="snippet_1f" highlight="19,31":::

## How to fix violations

Remove the nested `AsParameters` attribute:

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg9/Program.cs" id="snippet_1" highlight="17,29":::

## When to suppress warnings

This warning can ***not*** be suppressed.
