---
title: "RDG008: Multiple public constructors"
description: "Learn about analysis rule RDG008: Multiple public constructors"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
ms.author: safia
ms.date: 10/10/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg008
---
# RDG008: Multiple public constructors

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG008|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

This diagnostic is emitted by the [Request Delegate Generator](/aspnet/core/fundamentals/aot/request-delegate-generator/rdg) when an endpoint contains a route handler with a parameter annotated with the [`[AsParameters]`](xref:Microsoft.AspNetCore.Http.AsParametersAttribute) attribute with multiple public constructors.

### Rule description

Types that are used for surrogate binding via the `AsParameters` attribute must contain a single public constructor. The `TodoRequest` type produces this diagnostic because there are multiple public constructors.

<!--Sample code requires removing https from properties/launchsettings.json
 -->
:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg8/Program.cs" id="snippet_1" highlight="17,32-43":::

## How to fix violations

Provide a single public constructor.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg8/Program.cs" id="snippet_1f" highlight="17,45":::

## When to suppress warnings

This warning can be safely suppressed.
