---
title: "RDG007: No valid constructor found"
description: "Learn about analysis rule RDG007: No valid constructor found"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
ms.author: safia
ms.date: 09/15/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg007
---
# RDG007: No valid constructor found

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG007|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

This diagnostic is emitted by the [Request Delegate Generator](/aspnet/core/fundamentals/aot/request-delegate-generator/rdg) when an endpoint contains a route handler with a parameter annotated with the [`[AsParameters]`](xref:Microsoft.AspNetCore.Http.AsParametersAttribute) attribute with no valid constructor.

### Rule description

Types that are used for surrogate binding via the `AsParameters` attribute must contain a public constructor. The `TodoRequest` type produces this diagnostic because there is no public constructor.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg7/Program.cs" id="snippet_1" highlight="13-14,23-25":::

## How to fix violations

Remove the non-public constructor, or add a new public constructor.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg7/Program.cs" id="snippet_1f" highlight="13-15,18-22":::

## When to suppress warnings

This warning can't be safely suppressed. When suppressed, results in the  `InvalidOperationException` runtime exception.
