---
title: "RDG006: Invalid constructor parameters"
description: "Learn about analysis rule RDG006: Invalid constructor parameters"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
ms.author: safia
ms.date: 9/29/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg006
---
# RDG006: Invalid constructor parameters

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG006|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

This diagnostic is emitted by the [Request Delegate Generator](/aspnet/core/fundamentals/aot/request-delegate-generator/rdg) when an endpoint contains a route handler with a parameter annotated with the  [`[AsParameters]`](xref:Microsoft.AspNetCore.Http.AsParametersAttribute) attribute that contains an invalid constructor.

### Rule description

Types that are used for surrogate binding via the  [`[AsParameters]`](xref:Microsoft.AspNetCore.Http.AsParametersAttribute) attribute must contain a public parameterized constructor where all parameters to the constructor match the public properties declared on the type. The `TodoRequest` type produces this diagnostic because there is no matching constructor parameter for the `Todo` property.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg6/Program.cs" id="snippet_1" highlight="14,18-22":::

## How to fix violations

Ensure that all properties on the type have a matching parameter on the constructor.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg6/Program.cs" id="snippet_1f" highlight="14,18-22":::

## When to suppress warnings

This warning should ***not*** be suppressed. Suppressing the warning leads to a runtime exception associated with the same warning.
