---
title: "RDG005: Invalid abstract type"
description: "Learn about analysis rule RDG005: Invalid abstract type"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
ms.author: safia
content_well_notification: AI-contribution
ms.date: 9/27/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg005
ai-usage: ai-assisted
---
# RDG005: Invalid abstract type

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG005|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

This diagnostic is emitted by the [Request Delegate Generator](/aspnet/core/fundamentals/aot/request-delegate-generator/rdg) when an endpoint contains a route handler with a parameter annotated with the  [`[AsParameters]`](xref:Microsoft.AspNetCore.Http.AsParametersAttribute) attribute that is an abstract type.

### Rule description

The implementation of surrogate binding via the [`[AsParameters]`](xref:Microsoft.AspNetCore.Http.AsParametersAttribute) attribute in minimal APIs only supports types with concrete implementations. Using a parameter with an [abstract](/dotnet/csharp/language-reference/keywords/abstract) type as in the following sample produces the diagnostic.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg5/Program.cs" id="snippet_1" highlight="13, 17-21"::: Id, string Task);

## How to fix violations

Use  a concrete type for the surrogate:

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg5/Program.cs" id="snippet_1f" highlight="14,18-22":::

## When to suppress warnings

This warning should not be suppressed. Suppressing the warning will lead to a runtime exception assocaited with the same warning.
