---
title: "RDG004: Unable to resolve anonymous type"
description: "Learn about analysis rule RDG004: Unable to resolve anonymous type"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
content_well_notification: AI-contribution
ms.author: safia
ms.date: 09/15/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg004
ai-usage: ai-assisted
---
# RDG004: Unable to resolve anonymous type

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG004|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

This diagnostic is emitted by the [Request Delegate Generator](/aspnet/core/fundamentals/aot/request-delegate-generator/rdg) when an endpoint contains a route handler with an anonymous return type.

### Rule description

The Request Delegate Generator runs at compile-time and needs to be able to statically analyze route handlers in an app. [Anonymous types](/dotnet/csharp/fundamentals/types/anonymous-types) are generated with a type name only known to the complier and aren't statically analyzable. The following endpoint produces the diagnostic.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg4/Program.cs" id="snippet_1" highlight="13":::

## How to fix violations

Declare the route handler with a concrete type as the return type.

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg4/Program.cs" id="snippet_1f" highlight="13":::

## When to suppress warnings

This warning can be safely suppressed. When suppressed, the framework falls back to generating the request delegate at runtime.
