---
title: "RDG003: Unable to resolve parameter"
description: "Learn about analysis rule RDG003: Unable to resolve parameter"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
ms.author: safia
ms.date: 09/15/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg003
---
# RDG003: Unable to resolve parameter

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG003|
| **Fix is breaking or non-breaking** |Non-breaking|

## Future cause

This diagnostic is:

* Reserved for a future version of ASP.NET Core.
* Not currently emitted by the Request Delegate Generator. This diagnostic may be emitted in the next version of ASP.NET Core if it detects an endpoint contains a route handler with a parameter that can't be statically analyzed.

<!--
## Cause

This diagnostic is emitted by the Request Delegate Generator when an endpoint contains a route handler with a parameter that cannot be statically analyzed.

### Rule description

The Request Delegate Generator runs at compile-time and needs to be able to statically analyze route handlers in an application. This diagnostic is emitted when the 

```razor
var app = WebApplication.Create();

var version = "v1";
var route = $"/{version}/todos";

app.MapGet("/vl/todos", () => Results.Ok([new Todo(1, "Write tests"), new Todo(2, "Fix tests")]));

app.Run();

record Todo(int Id, string Task);
```

## How to fix violations

Declare the route pattern as an inline string literal in the route handler.
```razor
var app = WebApplication.Create();

app.MapGet("/v1/todos", () => Results.Ok([new Todo(1, "Write tests"), new Todo(2, "Fix tests")]));

app.Run();

record Todo(int Id, string Task);
```

## When to suppress warnings

This warning can be safely suppressed. When suppressed, the framework will fallback to generating the request delegate at runtime.
-->