---
title: "RDG002: Unable to resolve endpoint handler"
description: "Learn about analysis rule RDG002: Unable to resolve endpoint handler"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
ms.author: safia
ms.date: 09/15/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg002
---
# RDG002: Unable to resolve endpoint handler

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG002|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

This diagnostic is emitted by the Request Delegate Generator when an endpoint contains a route handler that can't be statically analyzed.

### Rule description

The Request Delegate Generator runs at compile-time and needs to be able to statically analyze route handlers in an app. The current implementation only supports route handlers that are provided as a lambda expression, method group references, or references to read-only fields or variables.

The following code generates the RDG002 warning because the route handler is provided as a reference to a method:

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg2/Program.cs" id="snippet_1" highlight="13-14,25-00":::

## How to fix violations

Declare the route handler using supported syntax, such as an inline lambda:

:::code language="csharp" source="~/../AspNetCore.Docs.Samples/fundamentals/aot/diagnostics/Rdg2/Program.cs" id="snippet_1f" highlight="13":::

## When to suppress warnings

This warning can be safely suppressed. When suppressed, the framework falls back to generating the request delegate at runtime.
