---
title: "RDG001: Unable to resolve route pattern"
description: "Learn about analysis rule RDG001: Unable to resolve route pattern"
author: captainsafia
monikerRange: '>= aspnetcore-8.0'
ms.author: safia
ms.date: 09/15/2023
uid: fundamentals/aot/request-delegate-generator/diagnostics/rdg001
---
# RDG001: Unable to resolve route pattern

<!-- UPDATE 9.0 Activate after release and INCLUDE is updated

[!INCLUDE[](~/includes/not-latest-version.md)]

-->

| | Value |
|-|-|
| **Rule ID** |RDG001|
| **Fix is breaking or non-breaking** |Non-breaking|

## Future cause

This diagnostic is:

* Reserved for a future version of ASP.NET Core.
* Not currently emitted by the Request Delegate Generator. This diagnostic may be emitted in the next version of ASP.NET Core if it detects an endpoint contains a route pattern that can't be statically analyzed such as route patterns that contain variable references.

<!--

## Cause

This diagnostic is emitted by the Request Delegate Generator when an endpoint contains a route pattern that cannot be statically analyzed including route patterns that contain variable references.

### Rule description

The Request Delegate Generator runs at compile-time and needs to be able to statically analyze route handlers in an application. The implementation does not currently support flow analysis to understand references to route pattern store in variables. The endpoint defined in the following application will produce the RDG001 diagnostic.

```razor
var app = WebApplication.Create();

var version = "v1";
var route = $"/{version}/todos";

app.MapGet(route, () => Results.Ok([new Todo(1, "Write tests"), new Todo(2, "Fix tests")]));

app.Run();

record Todo(int Id, string Task);
```

## How to fix violations

Declare the route pattern as an inline string literal in the route handler.
```razor
var app = WebApplication.Create();

app.MapGet("/v1/todos", () => Results.Ok([new Todo(1, "Write tests"), new Todo(2, "Fix tests")]));

app.Run();

record Todo(int Id, string Task);
```

## When to suppress warnings

This warning can be safely suppressed. When suppressed, the framework will fallback to generating the request delegate at runtime.
-->