---
title: "MVC1006: Methods containing TagHelpers must be async and return Task"
description: "Learn about analysis rule MVC1006: Methods containing TagHelpers must be async and return Task"
author: pranavkm
monikerRange: '>= aspnetcore-3.1'
ms.author: wpickett
ms.date: 10/22/2021
uid: diagnostics/mvc1006
---
# MVC1006: Methods containing TagHelpers must be async and return Task

| | Value |
|-|-|
| **Rule ID** |MVC1006|
| **Fix is breaking or non-breaking** |Breaking|

## Cause

A tag helper was defined inside a Razor function that executes synchronously

### Rule description

Tag Helper execution is asynchronous. When used inside a method or a lambda within a Razor Page, the containing function must also be declared to be async.


Consider the following cshtml file:

```razor
void Helper(string controller)
{
    <a asp-controller="@controller">Home</a>
}
```

`asp-controller` is a tag helper and will trigger this rule.

## How to fix violations

Declare the function to be async and Task returning:
```razor
async Task Helper(string controller)
{
    <a asp-controller="@controller">Home</a>
}
```

## When to suppress warnings

Do not suppress a warning from this rule.
