---
title: "MVC1005: Cannot use UseMvc with Endpoint Routing"
description: "Learn about analysis rule MVC1005: Cannot use UseMvc with Endpoint Routing"
author: pranavkm
monikerRange: '>= aspnetcore-3.1'
ms.author: riande
ms.date: 10/22/2021
uid: diagnostics/mvc1005
---
# MVC1005: Cannot use UseMvc with Endpoint Routing

| | Value |
|-|-|
| **Rule ID** |MVC1005|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

UseMvc was invoked as part of startup.

### Rule description

Using MVC via <xref:Microsoft.AspNetCore.Builder.MvcApplicationBuilderExtensions.UseMvc%2A> or <xref:Microsoft.AspNetCore.Builder.MvcApplicationBuilderExtensions.UseMvcWithDefaultRoute%2A> requires an explicit opt-in inside `Startup.ConfigureServices`. This is required because MVC must know whether it can rely on the authorization and CORS Middleware during initialization.

## How to fix violations

If the app requires legacy <xref:Microsoft.AspNetCore.Routing.IRouter> support, disable <xref:Microsoft.AspNetCore.Mvc.MvcOptions.EnableEndpointRouting>using any of the following approaches in `Startup.ConfigureServices`:

```csharp
services.AddMvc(options => options.EnableEndpointRouting = false);
```

If legacy `IRouter` support is not required, replace the call to `UseMvc`  with `UseEndpoints`. For more details, see the [migration guide](xref:migration/22-to-30#migrate-startupconfigure).

## When to suppress warnings

Do not suppress a warning from this rule.
