---
title: "MVC1003: Route attributes cannot be applied to page models"
description: "Learn about analysis rule MVC1003: Route attributes cannot be applied to page models"
author: pranavkm
monikerRange: '>= aspnetcore-3.1'
ms.author: wpickett
ms.date: 10/22/2021
uid: diagnostics/mvc1003
---
# MVC1003: Route attributes cannot be applied to page models

| | Value |
|-|-|
| **Rule ID** |MVC1003|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

An attribute implementing <xref:Microsoft.AspNetCore.Mvc.Routing.IRouteTemplateProvider> was applied to a Razor Page model.

### Rule description

Razor Page models are identified after routing is completed, and consequently cannot contribute a route. Applying a route attribute such as `Route` to a Razor Page model is not supported.

```csharp
[Route("/my-page-route")]
public class IndexModel : PageModel
{
    public IActionResult OnGet() => Page();
}
```

## How to fix violations

Remove the route attribute from the page model. Routes can be specified for a Razor Page using an `@page` directive or by using conventions. For more information, see [custom routes in Razor Pages](xref:razor-pages/index#custom-routes).

## When to suppress warnings

Don't suppress warnings from this rule.
