---
title: "MVC1002: Route attribute cannot be applied to page handler methods"
description: "Learn about analysis rule MVC1002: Route attribute cannot be applied to page handler methods"
author: pranavkm
monikerRange: '>= aspnetcore-3.1'
ms.author: wpickett
ms.date: 10/22/2021
uid: diagnostics/mvc1002
---
# MVC1002: Route attribute cannot be applied to page handler methods

| | Value |
|-|-|
| **Rule ID** |MVC1002|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

An attribute implementing <xref:Microsoft.AspNetCore.Mvc.Routing.IRouteTemplateProvider> was applied to a Razor Page handler method.

### Rule description

Razor Page handler methods are selected after routing is completed, and consequently cannot contribute a route. Applying a route attribute such as `HttpGet` or `HttpPost` to a Razor Page handler is not supported.

```csharp
public class IndexModel : PageModel
{
    [HttpGet("/my-url")]
    public IActionResult OnGet() => Page();
}
```

## How to fix violations

Remove the route attribute from the handler. Routes can be specified for a Razor Page using an `@page` directive or by using conventions. For more information, see [custom routes in Razor Pages](xref:razor-pages/index#custom-routes).

## When to suppress warnings

Don't suppress warnings from this rule.
