---
title: "MVC1001: Filters cannot be applied to page handler methods"
description: "Learn about analysis rule MVC1001: Filters cannot be applied to page handler methods"
author: pranavkm
monikerRange: '>= aspnetcore-3.1'
ms.author: wpickett
ms.date: 10/21/2021
uid: diagnostics/mvc1001
---
# MVC1001: Filters cannot be applied to page handler methods

| | Value |
|-|-|
| **Rule ID** |MVC1001|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

An attribute implementing <xref:Microsoft.AspNetCore.Mvc.Filters.IFilterMetadata> was applied to a Razor Page handler method.

### Rule description

Razor Page handler methods are selected after MVC filter execution has started, and consequently cannot contribute filters to execute. Applying a filter to a Razor Page handler is unsupported and always incorrect.

```csharp
public class IndexModel : PageModel
{
    [MyFilter]
    public IActionResult OnGet() => Page();
}
```

## How to fix violations

Remove the filter from the handler and apply it to the page model. If a filter has to be applied to a specific handler, consider using multiple Razor Pages.

```csharp
[MyFilter]
public class IndexModel : PageModel
{
    public IActionResult OnGet() => Page();
}
```

## When to suppress warnings

Don't suppress warnings from this rule.
