---
title: "MVC1000: Avoid using IHtmlHelper.Partial"
description: "Learn about analysis rule MVC1000: Use of IHtmlHelper.Partial should be avoided"
author: pranavkm
monikerRange: '>= aspnetcore-3.1'
ms.author: riande
ms.date: 10/21/2021
uid: diagnostics/mvc1000
---
# MVC1000: Use of IHtmlHelper.Partial should be avoided

| | Value |
|-|-|
| **Rule ID** |MVC1000|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

The <xref:Microsoft.AspNetCore.Mvc.Rendering.HtmlHelperPartialExtensions.Partial%2A> or <xref:Microsoft.AspNetCore.Mvc.Rendering.HtmlHelperPartialExtensions.RenderPartial%2A> method was called or referenced.

### Rule description

Rendering a partial using `IHtmlHelper.Partial` or `IHtmlHelper.RenderPartial` extension methods results in blocking calls. This may result in performance degradation and application dead locks issues due to thread pool starvation.

## How to fix violations

- Use the <xref:Microsoft.AspNetCore.Mvc.TagHelpers.PartialTagHelper>
- Use the <xref:Microsoft.AspNetCore.Mvc.Rendering.HtmlHelperPartialExtensions.PartialAsync%2A> or <xref:Microsoft.AspNetCore.Mvc.Rendering.HtmlHelperPartialExtensions.RenderPartialAsync%2A>

## When to suppress warnings

It's safe to suppress this rule if updating the application to use the suggested fixes is non-trivial. Before the validation is disabled, be sure to consider the risks of thread pool starvation to the application.
