---
title: "BL0006: Do not use RenderTree types"
description: "Learn about analysis rule BL0006: Do not use RenderTree types"
author: pranavkm
monikerRange: '>= aspnetcore-3.1'
ms.author: riande
ms.date: 10/21/2021
uid: diagnostics/bl0006
---
# BL0006: Do not use RenderTree types

| | Value |
|-|-|
| **Rule ID** |BL0006|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

A reference to a type in the <xref:Microsoft.AspNetCore.Components.RenderTree?displayProperty=fullName> was found.

## Rule description

Types in the `Microsoft.AspNetCore.Components.RenderTree` namespace are part of Blazor's implementation detail and are subject to breaking changes. Using these types is not recommended in user code.

## How to fix violations

Remove the reference to the type.

## When to suppress warnings

It is safe to suppress this rule if using this type is essential. Note that this these are subject to breaking changes between major releases.
