---
title: "BL0005: Component parameter should not be set outside of its component"
description: "Learn about analysis rule BL0005: Component parameter should not be set outside of its component"
author: pranavkm
monikerRange: '>= aspnetcore-3.1'
ms.author: riande
ms.date: 10/21/2021
uid: diagnostics/bl0005
---
# BL0005: Component parameter should not be set outside of its component

| | Value |
|-|-|
| **Rule ID** |BL0005|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

A property on a type deriving from <xref:Microsoft.AspNetCore.Components.ComponentBase> annotated with [`[Parameter]`](xref:Microsoft.AspNetCore.Components.ParameterAttribute) is being assigned to from outside the component.

## Rule description

Component parameters should be assigned to as part of the component initialization or as part of `SetParametersAsync`. Assigning a value to a parameter from an external source results in the value being overwritten the next time the component renders.

## How to fix violations

Consider using a distinct property to receive values from other components. Additional code can then be written to decide which of the two values to use in the component.

## When to suppress warnings

Do not suppress a warning from this rule.
