---
title: "BL0004: Component parameter should be public"
description: "Learn about analysis rule BL0004: Component parameter should be public"
author: pranavkm
monikerRange: '>= aspnetcore-3.1'
ms.author: riande
ms.date: 10/21/2021
uid: diagnostics/bl0004
---
# BL0004: Component parameter should be public

| | Value |
|-|-|
| **Rule ID** |BL0004|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Breaking|

## Cause

A property on a type deriving from <xref:Microsoft.AspNetCore.Components.ComponentBase> annotated with [`[Parameter]`](xref:Microsoft.AspNetCore.Components.ParameterAttribute) is not public.

## Rule description

Component parameters are required to be public and must have a public setter.

```razor
@code
{
    [Parameter] int Parameter1 { get; set; }
}
```

## How to fix violations

* Make the property and its setter public.

```razor
@code
{
    [Parameter] public int Parameter1 { get; set; }
}
```

* If making the property non-public is not possible, consider [implementing `SetParametersAsync` manually](xref:blazor/performance#implement-setparametersasync-manually).

## When to suppress warnings

Do not suppress a warning from this rule.
