---
title: "BL0003: Component parameter with CaptureUnmatchedValues has the wrong type"
description: "Learn about analysis rule BL0003: Component parameter with CaptureUnmatchedValues has the wrong type"
author: pranavkm
monikerRange: '>= aspnetcore-3.1'
ms.author: riande
ms.date: 10/21/2021
uid: diagnostics/bl0003
---
# BL0003: Component parameter with CaptureUnmatchedValues has the wrong type

| | Value |
|-|-|
| **Rule ID** |BL0003|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Breaking|

## Cause

A parameter on a type deriving from <xref:Microsoft.AspNetCore.Components.ComponentBase> annotated with <xref:Microsoft.AspNetCore.Components.ParameterAttribute.CaptureUnmatchedValues>`= true` is not assignable from `Dictionary<string, object>`

## Rule description

Parameters annotated with `CaptureUnmatchedValues = true` must be able to receive a `Dictionary<string, object>` value.

```razor
@code
{
    [Parameter(CaptureUnmatchedValues = true)] public IDictionary<string, string> Attributes { get; set; }
}
```

## How to fix violations

Change the type of the parameter to either `IDictionary<string, object>` or `Dictionary<string, object>`

```razor
@code
{
    [Parameter(CaptureUnmatchedValues = true)] public IDictionary<string, object> Attributes { get; set; }
}
```

## When to suppress warnings

Do not suppress a warning from this rule.
