---
title: "BL0002: Component has multiple CaptureUnmatchedValues parameters"
description: "Learn about analysis rule BL0002: Component has multiple CaptureUnmatchedValues parameters"
author: pranavkm
monikerRange: '>= aspnetcore-3.1'
ms.author: riande
ms.date: 10/21/2021
uid: diagnostics/bl0002
---
# BL0002: Component has multiple CaptureUnmatchedValues parameters

| | Value |
|-|-|
| **Rule ID** |BL0002|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

More than one parameter on a type deriving from <xref:Microsoft.AspNetCore.Components.ComponentBase> is annotated with `CaptureUnmatchedValues = true`.

## Rule description

For a component, exactly one parameter is expected to have the <xref:Microsoft.AspNetCore.Components.ParameterAttribute.CaptureUnmatchedValues> set to `true`.

```razor
@code
{
    [Parameter(CaptureUnmatchedValues = true)] public Dictionary<string, object> Parameter1 { get; set; }

    [Parameter(CaptureUnmatchedValues = true)] public Dictionary<string, object> Parameter2 { get; set; }
}
```

## How to fix violations

Limit a single parameter to have `CaptureUnmatchedValues` set.

```razor
@code
{
    [Parameter(CaptureUnmatchedValues = true)] public Dictionary<string, object> Parameter1 { get; set; }

    [Parameter] public Dictionary<string, object> Parameter2 { get; set; }
}
```

## When to suppress warnings

Do not suppress a warning from this rule.
