---
title: "BL0001: Component parameter should have public setters"
description: "Learn about analysis rule BL0001: Component parameter should have public setters"
author: pranavkm
monikerRange: '>= aspnetcore-3.1'
ms.author: riande
ms.date: 10/21/2021
uid: diagnostics/bl0001
---
# BL0001: Component parameter should have public setters

| | Value |
|-|-|
| **Rule ID** |BL0001|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Breaking|

## Cause

A property on a type deriving from <xref:Microsoft.AspNetCore.Components.ComponentBase> annotated with [`[Parameter]`](xref:Microsoft.AspNetCore.Components.ParameterAttribute) has a missing or non-public setters.

## Rule description

Component parameters are required to have publicly accessible setters to allow the framework to assign values. All of the parameter declarations in the following example result in this diagnostic.


```razor
@code
{
    [Parameter] int Parameter1 { get; set; }

    [Parameter] public int Parameter2 { get; }

    [Parameter] public int Parameter3 { get; private set; }
}
```

## How to fix violations

* Make the property and its setter public.

```razor
@code
{
    [Parameter] public int Parameter1 { get; set; }

    [Parameter] public int Parameter2 { get; set; }

    [Parameter] public int Parameter3 { get; set; }
}
```

* If making the property non-public is not possible, consider [implementing `SetParametersAsync` manually](xref:blazor/performance#implement-setparametersasync-manually).

## When to suppress warnings

Do not suppress a warning from this rule.
