---
title: "ASP0028: ## Analyzer to suggest using IPAddress.IPv6Any instead of IPAddress.Any if applicable" 
ms.date: 11/11/2024
description: "Consider using IPAddress.IPv6Any instead of IPAddress.Any"
author: deaglegross
monikerRange: '>= aspnetcore-10.0'
ms.author: dmkorolev
uid: diagnostics/asp0028
---
# ASP0028: Consider using `IPAddress.IPv6Any` instead of `IPAddress.Any`

|                                     | Value        |
| -                                   | -            |
| **Rule ID**                         | ASP0028      |
| **Category**                        | Usage        |
| **Fix is breaking or non-breaking** | Non-breaking |

## Cause

On the server machine that supports `IPv6`, [IPv6Any](/dotnet/api/system.net.ipaddress.ipv6any) is preferred to [Any](/dotnet/api/system.net.ipaddress.any) because `Any` can be slower than `IPv6Any`. In some cases, `Any` may not work at all. `Any` can be slower due to the [underlying System types implementation](https://github.com/dotnet/runtime/issues/82404).

`127.0.0.1` is the IPv4 loopback address. `::1` is the IPv6 loopback address. `Any` is the wildcard address for IPv4. `IPv6Any` is the wildcard address for IPv6.

Current behavior with with IPv6 when using  HTTP/1.x or HTTP/2.0:

* `localhost` resolves to `[::1]`.
* `[::1]` isn't accepted by the server, which forces a retry using `127.0.0.1`, creating a repeated cycle.

Using `Any` with the preceding conditions causes the `ASP0028` diagnostic message. Here's an example of the code that can result in these conditions:

```csharp
.UseKestrel().ConfigureKestrel(options =>
{ 
    options.Listen(IPAddress.Any, ...);
})
```

## Rule description

The recommended way to configure Kestrel to listen for incoming connections on all available `IPv6` network interfaces is with `IPv6Any`.

## How to fix violations

For the problematic code, replace `Any` with `IPv6Any`.

Use the <xref:Microsoft.AspNetCore.Server.Kestrel.Core.KestrelServerOptions.ListenAnyIP(System.Int32)> method without specifying any arguments:

```diff
.UseKestrel().ConfigureKestrel(options =>
{ 
-   options.Listen(IPAddress.Any, ...);
+   options.ListenAnyIP(...);
})
```

Or use the <xref:System.Net.IPAddress.IPv6Any> field:

```diff
.UseKestrel().ConfigureKestrel(options =>
{ 
-   options.Listen(IPAddress.Any, ...);
+   options.Listen(IPAddress.IPv6Any, ...);
})
```

## When to suppress warnings

The `ASP0028` diagnostic has [Information](/dotnet/api/microsoft.extensions.logging.loglevel) level severity. Suppress this warning if your intention is to disable `IPv6` usage completely on the server, although doing so risks the performance problems mentioned in this article.

`IPv6` can be disabled either system-wide, or for .NET only via the [AppCtx switch or environment variable](https://devblogs.microsoft.com/dotnet/dotnet-6-networking-improvements/#an-option-to-globally-disable-ipv6)
