---
title: "ASP0025: Use AddAuthorizationBuilder to register authorization services and construct policies."
ms.date: 05/11/2023
description: "Learn about analysis rule ASP0025: Use AddAuthorizationBuilder to register authorization services and construct policies."
author: tdykstra
monikerRange: '>= aspnetcore-8.0'
ms.author: tdykstra
uid: diagnostics/asp0025
---
# ASP0025: Use AddAuthorizationBuilder to register authorization services and construct policies.

| | Value |
|-|-|
| **Rule ID** |ASP0025|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

The use of  <xref:Microsoft.Extensions.DependencyInjection.PolicyServiceCollectionExtensions.AddAuthorization%2A> can be converted to the new <xref:Microsoft.Extensions.DependencyInjection.PolicyServiceCollectionExtensions.AddAuthorizationBuilder%2A>.

## Rule description

Use `AddAuthorizationBuilder` to register authorization services and construct policies.

## How to fix violations

To fix a violation of this rule, replace the usage of `AddAuthorization` with `AddAuthorizationBuilder`.

The code fix converts any usage of the setters for the following properties of <xref:Microsoft.AspNetCore.Authorization.AuthorizationOptions>:

* <xref:Microsoft.AspNetCore.Authorization.AuthorizationOptions.DefaultPolicy>
* <xref:Microsoft.AspNetCore.Authorization.AuthorizationOptions.FallbackPolicy>
* <xref:Microsoft.AspNetCore.Authorization.AuthorizationOptions.InvokeHandlersAfterFailure> 

These setter usages are converted to equivalent method calls on <xref:Microsoft.AspNetCore.Authorization.AuthorizationBuilder>:

* <xref:Microsoft.AspNetCore.Authorization.AuthorizationBuilder.SetDefaultPolicy%2A>
* <xref:Microsoft.AspNetCore.Authorization.AuthorizationBuilder.SetFallbackPolicy%2A>
* <xref:Microsoft.AspNetCore.Authorization.AuthorizationBuilder.SetInvokeHandlersAfterFailure%2A>

No diagnostic is reported when the configure action passed to `AddAuthorization` uses any of the following members of `AuthorizationOptions`:

* The <xref:Microsoft.AspNetCore.Authorization.AuthorizationOptions.GetPolicy(System.String)> method
* The <xref:Microsoft.AspNetCore.Authorization.AuthorizationOptions.DefaultPolicy> getter
* The <xref:Microsoft.AspNetCore.Authorization.AuthorizationOptions.FallbackPolicy> getter
* The <xref:Microsoft.AspNetCore.Authorization.AuthorizationOptions.InvokeHandlersAfterFailure> getter

`AuthorizationBuilder` doesn't have equivalents for these members of `AuthorizationOptions`, so they can't be converted.

No diagnostic is reported if the configure action passed to `AddAuthorization` contains operations unrelated to `AuthorizationOptions`. The code fix would not be able to automatically map unrelated operations to the fluent API of `AddAuthorizationBuilder`.

The following example shows code that triggers this diagnostic:

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Services.AddAuthorization(options =>
{
    options.AddPolicy("AtLeast21", policy =>
        policy.Requirements.Add(new MinimumAgeRequirement(21)));
});

var app = builder.Build();

app.UseAuthorization();

app.Run();
```

The following example shows the result of applying the code fix:

```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Services.AddAuthorizationBuilder()
  .AddPolicy("AtLeast21", policy =>
  {
        policy.Requirements.Add(new MinimumAgeRequirement(21)));
  });

var app = builder.Build();

app.UseAuthorization();

app.Run();
```

## When to suppress warnings

The severity level of this diagnostic is Information. Suppress warnings if you don't want to use the new syntax.
