---
title: "ASP0024: A route handler has multiple parameters with the [FromBody] attribute"
ms.date: 03/28/2023
description: "Learn about analysis rule ASP0024: A route handler has multiple parameters with the [FromBody] attribute"
author: tdykstra
monikerRange: '>= aspnetcore-8.0'
ms.author: tdykstra
uid: diagnostics/asp0024
---
# ASP0024: Route handler has multiple parameters with the `[FromBody]` attribute

| | Value |
|-|-|
| **Rule ID** |ASP0024|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

A route handler has multiple parameters with the [`[FromBody]`](xref:Microsoft.AspNetCore.Mvc.FromBodyAttribute) attribute or a parameter with an [`[AsParameters]`](xref:Microsoft.AspNetCore.Http.AsParametersAttribute) attribute where the parameter type contains multiple members with `[FromBody]` attributes.

## Rule description

Route handler has multiple parameters with the `[FromBody]` attribute.

## How to fix violations

To fix a violation of this rule, remove `[FromBody]` attributes from all but one parameter.

## When to suppress warnings

Do not suppress a warning from this rule.
