---
title: "ASP0023: Route conflict detected between route handlers"
description: "Learn about analysis rule ASP0023: Route conflict detected between route handlers"
author: tdykstra
monikerRange: '>= aspnetcore-8.0'
ms.author: tdykstra
ms.date: 3/24/2023
uid: diagnostics/asp0023
---
# ASP0023: Route conflict detected between route handlers

| | Value |
|-|-|
| **Rule ID** |ASP0023|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

An HTTP request matches multiple routes, resulting in an ambiguous match error.

## Rule description

This diagnostic is emitted when a route conflict is detected.

## How to fix violations

To fix a violation of this rule, change the route's pattern, HTTP method, or route constraints.

## When to suppress warnings

Do not suppress a warning from this rule.

## Notes

[ASP0022](xref:diagnostics/asp0022) warns on route conflicts in [minimal API](xref:fundamentals/apis) apps, this analyzer warns on route conflicts in ASP.NET Core MVC apps.
