---
title: "ASP0022: Route conflict detected between route handlers"
description: "Learn about analysis rule ASP0022: Route conflict detected between route handlers"
author: tdykstra
monikerRange: '>= aspnetcore-8.0'
ms.author: tdykstra
ms.date: 11/08/2023
uid: diagnostics/asp0022
---
# ASP0022: Route conflict detected between route handlers

| | Value |
|-|-|
| **Rule ID** |ASP0022|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

An HTTP request matches multiple routes, resulting in an ambiguous match error.

## Rule description

This diagnostic is emitted when a route conflict is detected.

## How to fix violations

To fix a violation of this rule, change the route's pattern, HTTP method, or route constraints.

## When to suppress warnings

Do not suppress a warning from this rule.

## Notes

[ASP0023](xref:diagnostics/asp0023) warns on route conflicts in ASP.NET Core MVC apps, this analyzer warns on route conflicts in [minimal API](xref:fundamentals/apis) apps.

This analyzer is intentionally conservative about duplicate routes it reports to avoid false positives:

* The analyzer only reports duplicate routes declared in the same code block in a method. Duplicate routes in different branches of an `if` statement aren't reported because the analyzer can't statically determine which will be used at runtime.
* The analyzer only reports duplicate routes with known metadata. Unknown methods called on a route handler might add new metadata that is then used to customize how the route is matched.

