---
title: "ASP0021: The return type of the BindAsync method must be ValueTask<T>"
description: "Learn about analysis rule ASP0021: When implementing the BindAsync(...) method, the return type must be ValueTask<T>."
author: tdykstra
monikerRange: '>= aspnetcore-8.0'
ms.author: tdykstra
ms.date: 03/27/2023
uid: diagnostics/asp0021
---
# ASP0021: The return type of the BindAsync method must be `ValueTask<T>`.

| | Value |
|-|-|
| **Rule ID** |ASP0021|
| **Category** |Usage|
| **Fix is breaking or non-breaking** |Non-breaking|

## Cause

An implementation of the <xref:Microsoft.AspNetCore.Http.IBindableFromHttpContext%601.BindAsync%2A> method has a return type that isn't <xref:System.Threading.Tasks.ValueTask%601>.

## Rule description

This diagnostic is emitted when an implementation of the `BindAsync` method has a return type that isn't `ValueTask<T>`.

## How to fix violations

To fix a violation of this rule, define a `ValueTask<T>` return type for `BindAsync` and consider implementing <xref:Microsoft.AspNetCore.Http.IBindableFromHttpContext%601> to enforce implementation.

## When to suppress warnings

Do not suppress a warning from this rule.
